﻿/* Constants */

var _STATUS_NOTSIGNEDON = 0;
var _STATUS_SIGNEDON = 1;
var _STATUS_WAITING = 2;
var _STATUS_PAUSED = 3;
var _STATUS_INTERVIEW = 4;
var _STATUS_WRAPUP = 5;

var _ANSWER_ERR = 0;
var _ANSWER_INCALL = 1;
var _ANSWER_NOTINCALL = 2;
var _ANSWER_NOINTWEBURL = 3;
var _ANSWER_JAVASCRIPT_ERROR = 4;

/* Advance Line Status */
var ADVST_NULL = 0;
var ADVST_CONNECTED = 1; // Line connected
var ADVST_HOLD = 2; // Line in Hold
var ADVST_DIAL = 3; // Line Dialing
var ADVST_HANGUP = 4; // Line in Hangup

var _lineStatus = [ "ADVST_NULL", "ADVST_CONNECTED" , "ADVST_HOLD", "ADVST_DIAL" , "ADVST_HANGUP" ] ;

/* Transfer IVRMM KeepAgent Resume result */
var _KA_RESUME = "TR"; // The caller resume and come back to agent
var _KA_QUIT = "TQ";   // The caller as quit, the agent must wrap-up
var _KA_LOST = "TL";   // The caller was transfered, the agent must wrap-up

/*  Toolbar vars */
var _lastBtns = "";
var _statusTimerStart = null;

/* Pronto vars */

var _hiddens = null;
var _lastCallWait = null;
var _wsCallGetCase = null;


/* Other vars */
var _isPlaying = false;
var _isRecording = false;
var _oldPrefValues = null;
var _lastKeyPressed = null;

var _waitInProcess = false;
var _pauseInProcess = false;
var _hangupInProcess = false;

var _displayAlert = null;

/* Visual cue handling */
var _visualCue = null;

/* Browser definition */
var _IEVersion = 0;
var _lineNo = 0;




// closesentinel.aspx 
function IsValidHtmlIntWebPage(_doc) {
    if (_doc != null && _doc != undefined && _doc.documentElement != null && _doc.documentElement != undefined) {
        var _tagName = _doc.documentElement.tagName;
        if (_tagName != null && _tagName != undefined) {
            if (_tagName.toUpperCase().indexOf("HTML") == -1) {
                return false;
            }
        }
        if (_doc.documentElement.outerHTML != null && _doc.documentElement.outerHTML != undefined) {
            // IE validation - Not working with FierFox
            var _tagContent = _doc.documentElement.outerHTML;
            if (_tagContent.toUpperCase().lastIndexOf("</" + _tagName.toUpperCase() + ">") > 0) {
                if ((_tagContent.toUpperCase().indexOf("<" + _tagName.toUpperCase() + ">") != 1) ||
                  (_tagContent.toUpperCase().indexOf("<" + _tagName.toUpperCase() + " ") != 1)) {
                    return true;
                }
            }

        } else {
            //-----------------------------------------------------------------------------------------------------------
            // Firefox or other browser validation.
            // We should do the validation on server side because the document outerHTML tag is not supported in FireFox.
            // Some client use the FireFox as the web browser.
            //-----------------------------------------------------------------------------------------------------------
            if (_doc.documentElement.innerHTML != null && _doc.documentElement.innerHTML != undefined) {
                var _tagContent = _doc.documentElement.innerHTML;
                if (_tagContent.lastIndexOf("</body>") > 0) {
                    if ((_tagContent.indexOf("<body>") != 1) || (_tagContent.indexOf("<body ") != 1)) {
                        return true;
                    }
                }
            }
        }
    }

    return false;
}


function initSession() 
{
    createPLCookie('InInterview', false, 1);
}



//US1228 RK: LineNos will add up all numbers, will be modified upon gotWaitAnswer and when HangUp
var _lineNos = new Hashtable();
var _phoneNoSaved = "";
//US1228

function AdvanceLogTrace() {

    var m_transferThat = this;
    var m_Log = false;


    this.Log = function (trace) {
        try {

            if (typeof m_Log != "boolean" || m_Log == false) {
            return;
        }

            Logger._debug(trace);
    }
        catch (e) {

        }
    }

    this.Enable = function (bLog) {
        if (bLog == undefined) {
            return;
        }
        m_Log = bLog;
    }
}

function buttonClass() {

    var that = this;
    var button = [];
    button['btnWait'] = '0';
    button['btnLastCall'] = '0';
    button['btnPause'] = '0';

    this.toggleButton = function (buttonId, value) {

        //
        //
        // on respect l'agorithme deja en place par le code germanique de marde...
        //
        //  Ca ressemble a de l'assembleur ou la position des 0 et de 1 on une signification. Avec cette algorithme nous avons trois position
        //
        //  premiere position pour le bouton wait
        //  deuxieme position pour le bouton pause
        //  trosieme position pour le bouton last call ...
        //
        //  Valeur 1 -> actif
        //  valeur 0 -> inactif
        //
        //  Exemple :
        //
        //  100
        //  
        //  Bouton wait actif 
        //  Bouton pause inactif 
        //  Bouton last  inactif
        //

		var SampleManager = gClassManager.getNoSampleClass();
        value = that.Set(buttonId, value);


        if (buttonId == 'btnWait') {
	        if (value == true) {

                if (SampleManager != null && SampleManager != undefined) {
                    SampleManager.SetDisplayAllow(true);
                }

                button['btnLastCall'] = '0';
                button['btnPause'] = '0';
            }
        }

        if (buttonId == 'btnPause') {
            button['btnWait'] = '0';
        }

        return that.getButtonStatus();
    }

    this.Set = function (buttonId, value) {


        if (value != undefined) {
            //
            //  le parametre value est difini alors nous prenons cette valeur
            //
            var set = value == true ? '1' : '0'
            button[buttonId] = set;
            return value;
        }

        //
        //  Si la valeur n'est pas defini nous effetuons un toggle... Logique déja existante lors du retrait de AJAX PRO
        //

        var toggleBool = button[buttonId] == '0' ? true : false;
        button[buttonId] = toggleBool == true ? '1' : '0';

        return toggleBool;
    }

    this.getButtonStatus = function () {
        var result = button['btnWait'] + button['btnPause'] + button['btnLastCall'];
        return result;
    }
}


var gTimer = new timer;
var gButtonClass = new buttonClass;
var gNoSampleAvailable = null;


function badClosing() {

    try {
        closeSentinel = gClassManager.getCloseSentinelFrame();
        if (closeSentinel.userClickCloseSession() == true)
            return;

        var message = "";
        switch (closeSentinel._status) {
            case _STATUS_NOTSIGNEDON:
            case _STATUS_SIGNEDON:
            case _STATUS_PAUSED:
                message = "The agent is idle. No side effect of closing the browser after pressing the X button";
                break;
            default:
                message = "The agent is in call with a respondent. Closing the browser with the X button might dropped the current call";
                break;
        }
    }
    catch (e) {
        message = "Not able to determine the agent status because of a javascript exception -- " + e.message;
    }


    var additionnalSetting = {};
    additionnalSetting.async = true;
    iCommon.callServerMethod("CloseSentinel.aspx", "badClosing", { szMessage: message }, function (result) { var response = result; }, function (xhr, msg, e) { }, additionnalSetting);
    }


function NoSampleAvailable() {

	var m_SampleManager = this ;
    var m_szTooltip = "" ;
	var m_NoSampleIcon = null;
    var m_NoSampleIconTxt = null;
	var m_bDisplayAllow = false ;
    

    this.SetDisplayAllow = function (allow) {
        m_bDisplayAllow = allow;
    };

    this.SetDefault = function () {

        var toolbar = gClassManager.getToolbar();

        if (m_NoSampleIcon == undefined || m_NoSampleIcon == null) {

            var config = gClassManager.getConfigManager();
            if (config != undefined && config != null) {
                m_szTooltip = config.GetNoSampleMessage();
            }

            m_NoSampleIcon = toolbar.document.getElementById('trNoSample');
            m_NoSampleIconTxt = toolbar.document.getElementById('trNoSampleTxt');
        
            var img = toolbar.document.getElementById('imgNoSample');
            if (img != undefined && img != null) {
                img.title = m_szTooltip;
            }
         
        }

        return;
    };

    this.Set = function () {

        if (m_bDisplayAllow == false) {
            //
            //  l'Agent n'est pas en wait
            //
            return;
        }

        var toolbar = gClassManager.getToolbar();
        if (m_NoSampleIcon == undefined || m_NoSampleIcon == null) {

            //
            //  Si personne a effectuer le set default, nous l'efffectuons ici. 
            //
            this.SetDefault();
            if (m_NoSampleIcon == undefined) {
                return;
            }
        }

        m_NoSampleIconTxt.style.display = '';
        m_NoSampleIcon.style.display = '';

    };

    this.Reset = function () {

        if (m_NoSampleIcon == undefined || m_NoSampleIcon == null) {

            //
            //  Si personne a effectuer le set default, nous l'efffectuons ici. 
            //

            this.SetDefault();
            if (m_NoSampleIcon == undefined) {
                return;
            }
        }

        m_NoSampleIconTxt.style.display = 'none';
        m_NoSampleIcon.style.display = 'none';

    };
}




function timer() 
{
    var start = 0;
    var count = 0;
    var laststatus;
    var statusTimerId = 0;


    this.Start = function ()
    {
        if (statusTimerId != 0)
        {
            return;
        }

        start = new Date();
        statusTimerId = setInterval("setIntervalCallBack();", 1000);
        return;
    }

    this.timerCallBack = function ()
    {

        var _cnt = document.getElementById('statusCnt');
        if (_cnt != null) {
            var timevalue = this.Get();
            _cnt.innerHTML = timevalue;
        }

        return;
    }

    this.Reset = function ()
    {
        if (statusTimerId == 0)
        {
            this.Start();
            return;
        }

        if (arguments.length == 0)
        {
            start = new Date();
            return;
        }

        var status = arguments[0];
        if (status != laststatus)
        {
            laststatus = status;
            status = null;
            start = new Date();
        }

        return;
    }

    this.StopInterval = function ()
    {
        if (statusTimerId != 0) 
        {
            clearInterval(statusTimerId);
            statusTimerId = 0;
        }
    }

    this.Get = function () 
    {
        var diff = new Date() - start; // Nb Ms
        diff /= 1000;

        var h = Math.floor(diff / 3600);
        diff -= h * 3600;

        var m = Math.floor(diff / 60);
        diff -= m * 60;

        var s = Math.round(diff);
        if (s > 59) {
            s = 59; // Rounding pb
        }

        while (h >= 24) 
        {
            h -= 24;
        }

        var str = '';
        if (h < 10) 
        {
            str = '0';
        }

        str += h + ':';
        if (m < 10) 
        {
            str += '0';
        }

        str += m + ':';
        if (s < 10) 
        {
            str += '0';
        }

        str += s;
        return (str);
    }
}


function setIntervalCallBack() 
{
    gTimer.timerCallBack();
    return;
}

function getCommandResult(_cmdMsg) 
{
    var _errStr = null;
    if (_cmdMsg != null && _cmdMsg != undefined) 
    {
        if (_cmdMsg.indexOf(';') != -1) 
        {
            var _vals = _cmdMsg.split(';');
            if (2 === _vals.length && 'ERR' === _vals[0]) 
            {
                if ('PRONTOSERVER-UNREACHABLE' === _vals[1]) {
                    _errStr = getTranslatedString("STR_PRONTOSERVER_UNREACHABLE");
                } 
                else if ('PRONTOSERVER-SESSION-ENDED' === _vals[1]) {
                    _errStr = getTranslatedString("STR_PRONTOSERVER_SESSION_ENDED");
                } 
                else if ('AGENT-NOT-ONLINE' === _vals[1]) {
                    _errStr = getTranslatedString("STR_AGENT_NOT_ONLINE");
                } 
                else if ('AGENT-STILL-CONNECTED' === _vals[1]) {
                    _errStr = getTranslatedString("STR_AGENT_STILL_CONNECTED");
                }
                else if ('AGENT-ALREADY-CONNECTED' === _vals[1]) {
                    _errStr = getTranslatedString("STR_AGENT_STILL_CONNECTED");
                } 
                else if ('AGENT-ALREADY-LOGGED-IN' === _vals[1]) {
                    _errStr = getTranslatedString("STR_AGENT_ALREADY_LOGGED_IN");
                } 
                else if ('REMOTE-STATION-DELETED' === _vals[1]) {
                    _errStr = getTranslatedString("STR_REMOTE_STATION_DELETED");
                } 
                else if ('NO-LINE-TO-DIAL-OUT-REMOTE-AGENT' === _vals[1]) {
                    _errStr = getTranslatedString("STR_NO_LINE_TO_DIAL_OUT_REMOTE_AGENT");
                } 
                else if ('CANNOT-LOGIN-PROJECT' === _vals[1]) {
                    _errStr = getTranslatedString("STR_SIGNEDON_FAILED");
                } 
                else if ('COMMAND-DENIED-AT-THIS-TIME' === _vals[1]) {
                    _errStr = getTranslatedString("STR_COMMAND_DENIED_AT_THIS_TIME");
                } 
                else if ('AGENT-NOT-SIGNED-ON' === _vals[1]) {
                    _errStr = getTranslatedString("STR_SIGNEDON_FAILED");
                } 
                else if ('EXTENSION-NOT-SIGNED-ON' === _vals[1]) {
                    _errStr = getTranslatedString("STR_EXTENSION_NOT_SIGNED_ON");
                } 
                else if ('PROJECT-NOT-ACTIVE' === _vals[1]) {
                    _errStr = getTranslatedString("STR_PROJECT_NOT_ACTIVE");
                } 
                else if ('AGENT-NOT-IN-CALL' === _vals[1]) {
                    _errStr = getTranslatedString("STR_AGENT_NOT_IN_CALL");
                } 
                else if ('WKS-NOT-ACTIVE' === _vals[1]) {
                    _errStr = getTranslatedString("STR_WKS_NOT_ACTIVE");
                } 
                else if ('REMOTE-MODULE-NOT-ACTIVE' === _vals[1]) {
                    _errStr = getTranslatedString("STR_REMOTE_MODULE_NOT_ACTIVE");
                } 
                else if ('AGENT-LOGOUT-DIALER-DOWN' === _vals[1]) {
                    _errStr = getTranslatedString("STR_AGENT_LOGOUT_DIALER_DOWN");
                } 
                else if ('AGENT-IN-CALL' === _vals[1]) {
                    _errStr = getTranslatedString("STR_PauseDenied");
                }
            }
        }
    }
    return _errStr;
}


function WebServiceCall(_asmxUrl, _method) 
{
    var _methodName = _method;
    var _methodParams = null;
    var _callback = null;
    var _objXmlHttp = CreateXmlHttpObject();
    var _serviceUrl = _asmxUrl;
    var _errorMessage = null;
    var _completed = false;
    var _aborted = false;
    this.getAjaxObj = function () {return _objXmlHttp;};
    this.getErrorMessage = function () {return _errorMessage;};
    this.setParams = function (_arr) 
    {
        if (null === _arr || 0 === _arr.length) {
            _methodParams = null;
        } 
        else {
            // array of string (name1,value1,name2,value2...
            if (0 === (_arr.length % 2)) {
                _methodParams = _arr;
            }
        }
    };
    this.getURL = function () 
    {
        return _serviceUrl;
    };
    this.getMethod = function () 
    {
        return _methodName;
    };
    this.getThisPtr = function () 
    {
        return this;
    };


    this.abort = function () {
        if (_objXmlHttp != null) {
            var x = this._serviceUrl;
            _aborted = true;
            _objXmlHttp.abort();
           // _methodParams = null;
            _completed = true;
            error('Abort(): ' + x);
        }
    };

    
    function CreateXmlHttpObject() 
    {
        var _oXmlHttp = null;
        if (navigator.userAgent.indexOf("Opera") >= 0) {
            _errorMessage = "Opera is not supported.";
            return null;
        }
        if (navigator.userAgent.indexOf("MSIE") >= 0) {
            var strName = "Msxml2.XMLHTTP";
            if (navigator.appVersion.indexOf("MSIE 5.5") >= 0) {
                strName = "Microsoft.XMLHTTP";
            }
            try 
            {
                _oXmlHttp = new ActiveXObject(strName);
                return _oXmlHttp;
            } 
            catch (e) 
            {
                _errorMessage = "CreateXmlHttpObject> Not able to instanciate the AJAX object. Error. Scripting for ActiveX might be disabled: " +e.message;
                error(_errorMessage);
                return null;
            }
        }
        if (navigator.userAgent.indexOf("Mozilla") >= 0) {
            _oXmlHttp = new XMLHttpRequest();
            return _oXmlHttp;
        }
        return (null);
    }

    function CreateSoapEnveloppe(_method, _params) 
    {
        var _s = "";
        _s += "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        _s += "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">";
        _s += "<soap:Body>";
        _s += "<" + _method + " xmlns=\"http://www.voxco.com/\">";
        if (_params != null) 
        {
            var i;
            for (i = 0; i < _params.length; i += 2) 
            {
                _s += "<" + _params[i] + ">" + _params[i + 1] + "</" + _params[i] + ">";
            }
        }
        _s += "</" + _method + ">";

        _s += "</soap:Body></soap:Envelope>";
        trace('CreateSoapEnveloppe for ' + _method + ': [' + _s + ']');
        return (_s);
    }

    function ParseResponse(_s) 
    {
        debug('ParseResponse for ' + _methodName + ': [' + _s + ']');
        var _ss = "";
        var _srch = _methodName + 'Result';
        var _p = _s.indexOf('<' + _srch);
        if (_p != -1) {
            _ss = _s.substr(_p);
            _p = _ss.indexOf('</' + _srch);
            if (_p != -1) {
                _s = _ss.substr(0, _p + 3 + _srch.length);
                // s= <xResult>0</xResult>
                _s = _s.substr(_s.indexOf('>') + 1);
                _s = _s.substr(0, _s.lastIndexOf('<'));
            } 
            else {
                _p = _ss.indexOf('</' + _methodName + "Response>");
                if (_p != -1) {
                    _ss = _ss.substr(0, _p);
                    _p = _ss.indexOf('>');
                    if (_p === _ss.length - 1) {
                        _s = ""; // <xResult/> : no data
                    }
                }
            }
        } 
        else {
            _s = ""; //no result or null
        }
        return (_s);
    }

    this.execute = function () {
        try {
            if (_objXmlHttp != null) {
                _objXmlHttp.abort();
                if (arguments.length > 0) { _callback = arguments[0]; }
                if (null === _methodName || 0 === _methodName.length) {
                    _errorMessage = 'Invalid method';
                }
                else if (null === _serviceUrl || 0 === _serviceUrl.length) {
                    _errorMessage = 'Invalid URL';
                }
                else {
                    var _soap = CreateSoapEnveloppe(_methodName, _methodParams);

                    _objXmlHttp.onreadystatechange = this.processStateChanged;
                    _objXmlHttp.open("POST", _serviceUrl, true);
                    _objXmlHttp.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
                    _objXmlHttp.setRequestHeader("SOAPAction", "\"http://www.voxco.com/" + _methodName + "\"");
                    _objXmlHttp.send(_soap);
                }
            }
        }
        catch (e) {
            _errorMessage = 'Execute exception: ' + e.message;
        }
        if (_errorMessage != null) {
		    error('execute - _errorMessage=' + _errorMessage);
		    if (_callback!=null){_callback(false, this,_errorMessage);}
		    else { DialogBox.showAlert('XmlHttp: ' + _errorMessage); }
        }
    };

    this.processStateChanged = function () {

        var _errorMessage = null;
        try {

           
            if (null === _objXmlHttp) {
                trace('processStateChanged null objXmlHttp');
                _completed = true;
                return;
            }

            trace('processStateChanged ' + _methodName + ' - readyState=' + _objXmlHttp.readyState);
            if (4 === _objXmlHttp.readyState || _objXmlHttp.readyState === "complete") {
                trace('processStateChanged - status=' + _objXmlHttp.status);

                if (_aborted) { warning('call was aborted'); _completed = true; return; }
                if (200 === _objXmlHttp.status) {
                    if (_callback != null) {
                        _callback(true, this, ParseResponse(_objXmlHttp.responseText));
                    }
                    _objXmlHttp.abort();
                    //_methodParams = null;
                    _completed = true;
                    return;
                }
                _errorMessage = 'Error: HTTP code = ' + _objXmlHttp.status;
                _completed = true;
                _aborted = true;
                _objXmlHttp.abort(); // PG WORTH TRYING
                //_methodParams = null;
            }
        }
        catch (e) {
            _errorMessage = 'Exception: ' + e.message;
            _completed = true;
        }

        if (_errorMessage != null) {
            error('processStateChanged> An error occured during the ajax request -- error: ' +_errorMessage);
            if (_callback != null) { _callback(false, this, _errorMessage); }
            else { DialogBox.showAlert('State changed error: ' + _errorMessage); }
        }

    }

}

function Hash() 
{
    this.length = 0;
    this.items = new Array();
    this.keys = new Array();
    for (var i = 0; i < arguments.length; i += 2) {
        if (typeof (arguments[i + 1]) != 'undefined') {
            this.keys.push(arguments[i]);
            this.items[arguments[i]] = arguments[i + 1];
            this.length++;
        }
    }

    this.toString = function () {

        if (this.length == 0)
            return "";

        var string;
        for (property in this.items)
            string += "name: " + property + " value: " + this.items[property] + "\n"

        return string;
    };

    this.removeItem = function (in_key) 
    {
        var tmp_previous = null;
        if (typeof (this.items[in_key]) != 'undefined') {
            this.length--;
            tmp_previous = this.items[in_key];
            delete this.items[in_key];
        }
        return tmp_previous;
    };

    this.getCmdCount = function()
    {
        var count = this.items["CMDCOUNT"];
        if (typeof count == "undefined")
            count = "0";

        return count;
    }

    this.getBool = function (in_key, defaultValue) {

        var value = this.items[in_key];
        if (typeof value == 'undefined')
            return defaultValue;

        switch (value) {

            case '0':
            case 'False':
            case 'false':
            case 'FALSE':
                value = "false";
                break 

            case '1':
            case 'True':
            case 'true':
            case 'TRUE':
                value = "true";
                break;
            default:
                value = 'false';
                if (value > 0 || value < 0 )
                    value = 'true';

                break;
        }

        return value;
    }

    this.getItem = function (in_key, defaultValue) {

        var value = this.items[in_key];
        if (typeof value == 'undefined')
            value = defaultValue ;

        return value;
    };

    this.setItem = function (in_key, in_value) 
    {
        var tmp_previous;
        if (typeof (in_value) != 'undefined') {
            if (typeof (this.items[in_key]) === 'undefined') {
                this.length++;
                this.keys.push(in_key);
            } 
            else {
                tmp_previous = this.items[in_key];
            }
            this.items[in_key] = in_value;
        }
        return tmp_previous;
    };

    this.hasItem = function (in_key) 
    {
        return typeof (this.items[in_key]) != 'undefined';
    };

}

function onTBPageLoaded() 
{
    trace('onTBPageLoaded - START');
    var _f2 = gClassManager.getSharedFrame();
    if (_f2.document.location.href.search('intweb') != -1) {  // Check IntWebButtons only when IntWeb is loaded in the shared frame
        CheckIntWebButtons();
    }

    initVAToolBar();

    var _btn = null;
    var tbWebcontrol = gClassManager.getTBWebControl();

    if (tbWebcontrol !== 'undefined') {
        try {

            if (tbWebcontrol.getEnable('btnLastCall') == false) {
                tbWebcontrol.setButtonStyle('btnLastCall', false, false);
        }

    } catch (e) {
            error("onTBPageLoaded> Exception in btnLastCall; " + e.message);
    }

        try {
            if (tbWebcontrol.getEnable('btnPause') == false) {
                tbWebcontrol.setButtonStyle('btnPause', false, false);
        }

    } catch (e) {
            error("onTBPageLoaded> Exception in btnPause -- error: " + e.message);
    }

    refreshStatus();
    afterVATBLoaded();
}
    else {
        warning("onTBPageLoaded> tbWebcontrol not loaded; " + e.message);
    }

    trace('onTBPageLoaded - END');
}

function CheckIntWebButtons() 
{
    //
    // En mode cati seulement pas besoin de bouton wait. Seulement disponible avec un module telephonique
    //  
    if (isPureCATI() == true ) { return; }

   
    var set = gClassManager.getButtonClass().toggleButton('btnWait', false);
    setBtnFromStatus(set, false);
}

function isTbButtonEnabled(_btnId) 
{
    var tbWebcontrol = gClassManager.getTBWebControl();
    return tbWebcontrol.getEnable(_btnId );
}

function enableTbButton(_btnId, _bSet) {

    var tbWebcontrol = gClassManager.getTBWebControl();
    var toolbar = gClassManager.getToolbar();

    if (tbWebcontrol == undefined || tbWebcontrol == null) {
        return;
    }

    // Change image of buttons
    if ('btnAdvanced' === _btnId) {
        tbWebcontrol.setImage(_btnId, _bSet, 'dis.png', '.png');
        return;
    }

    if ('btnLastCall' === _btnId || 'btnPause' === _btnId || 'btnWait' === _btnId || 'btnProjects' === _btnId || 'btnPref' === _btnId || 'btnHangup' === _btnId || 'btnExit' === _btnId) {
        tbWebcontrol.setImage(_btnId, _bSet, '_dis.gif', '.gif');
        return;
    }
}


function setBtnFromStatus(_s, _rstTimer, btn) {

    var Logger = gClassManager.getNewLogger();
    var AgentAssignment = gClassManager.getAgentAssignmentClass();

    try {

        if (undefined === _s || null === _s || _s.length != 3) {
            return;
        }

        Logger._trace('setBtnFromStatus (' + _s + ')');
        if (false === isPureCATI()) {

            var tbWebcontrol = gClassManager.getTBWebControl();

            tbWebcontrol.setButtonStyle('btnWait', ('0' != _s.charAt(0)), false);
            tbWebcontrol.setButtonStyle('btnPause', ('0' != _s.charAt(1)), false);
            tbWebcontrol.setButtonStyle('btnLastCall', ('0' != _s.charAt(2)), true);
        }

        if (typeof btn == "string" && btn == "btnLastCall") {
            var bLastCall = '0' != _s.charAt(2);
            AgentAssignment.setLastCall(bLastCall, "setStatesFromSrv");
        }
    }
    catch (e) {

    }
}

function RedirectMainPage(_url) 
{
    var _f2 = gClassManager.getSharedFrame();
    if (_f2 != null) {_f2.location = _url;}
}

function refreshButtons() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.toolbarIsReloaded != undefined)
        _f0.toolbarIsReloaded();

    refreshVAToolbar();
}

function onClickBtn(oButton, oEvent) 
{

    if (oButton == null) {
        return;
    }

    var toolbar = gClassManager.getToolbar();
    if ( typeof toolbar == "object" && toolbar != null )
        toolbar.eraseCallResultMsg();

    btnClicked(oButton.getID());
}

function btnClicked(_btnId) 
{
    var _CloseSentinel = gClassManager.getCloseSentinelFrame();
    if (_CloseSentinel.SessionTimeout != null && typeof _CloseSentinel.SessionTimeout == "object")
        _CloseSentinel.SessionTimeout.Touch();
   
    var Logger = gClassManager.getNewLogger();
    var bClickEnable = true;

    var tbWebcontrol = gClassManager.getTBWebControl();
    if (typeof tbWebcontrol == "object" )
        bClickEnable = tbWebcontrol.getEnable( _btnId ) ;
    else
        Logger._error('btnClicked> The tbWebcontrol object does not exist anymore on button ' +_btnId );

    Logger._trace('btnClicked> Button  ' +_btnId + ' has been click and the onclick is ' + bClickEnable);
    if (_btnId === "btnExit") {

        if (bClickEnable == true) {
            closeCurrentProject(true);
            top.window.location = "CloseSession.aspx";
        }
    }
    else if (_btnId === "btnPref") {

        if (_CloseSentinel != null && _CloseSentinel != undefined) {
            _CloseSentinel._changingPreference = true;

            PrefDlgBox();

            _CloseSentinel._changingPreference = false;
        }
    }
    else if (_btnId === "btnHelp") {
        HelpWindow();
    }
    else if (_btnId === "btnProjects") {

        if (bClickEnable == true) {
            var configClass = gClassManager.getConfigManager();
            configClass.ClearThreadId();
            RedirectMainPage("SelectProjects.aspx?CancelAutoLogin=1");
            gClassManager.getButtonClass().toggleButton('btnPause', false);
            setStatus(_STATUS_NOTSIGNEDON);
        }

    }
    else if (_btnId === "btnDialNow") {

        if (_CloseSentinel != undefined && _CloseSentinel != null) {
            _CloseSentinel.stopDialDelayTimer();
            _CloseSentinel.snoozeDialDelayTimer();
        }
    }
    else if (_btnId === "btnSnooze") {

        if (_CloseSentinel != undefined && _CloseSentinel != null) {
            _CloseSentinel.snoozeDialDelayTimer();
        }
    }
    else if (false === isPureCATI()) {

        if ((_btnId === "btnWait" || _btnId === "btnPause") && bClickEnable == true) {
            if (_btnId === "btnWait" && IsWaiting() == true) {
                // Cancel waiting ?
                return;
            }
            else if (_btnId === "btnPause" && IsPaused() == true) {
                // Already in pause
                return;
            }
            else {
                // Execute wait or pause command
                if (false === NotifyProntoFromBtn(_btnId)) { CheckIntWebButtons(); }
            }
        }
        else if (_btnId === "btnLastCall") {

            if (bClickEnable == true) {
                toggleState(_btnId);
        }
        }
        else if (_btnId === "btnHangup") {

            if (bClickEnable == true) {
                NotifyProntoFromBtn(_btnId)
            }
        }
        else if (_btnId === "btnAdvanced") {

            if (bClickEnable == true)
                overlay();
        }
        else {
            Logger._warning('btnClicked> Button  ' + _btnId + ' has been click but is ignored');
        }
    }
    else {
        Logger._warning('btnClicked> Button  ' + _btnId + ' has been click but is ignored');
    }

    return ;
}

function ModuleAdvancedFeatures(_show, _enableTbButton,_tr) {
    var result = false;
    if (_tr == null || _tr == undefined)
        _tr = document.getElementById('btnAdvancedTr');

    var configClass = gClassManager.getConfigManager();
    if (_show == false || configClass == undefined) {
        _tr.style.display = 'none';
        closeDialog();
        return result;
    }

    var advanceSetting = configClass.GetAdvanceSettingClass();
    if (advanceSetting == null || advanceSetting.m_bAdvanceModeEnable == false) {
        _tr.style.display = 'none';
        closeDialog();
        return result;
    }

    _tr.style.display = '';
    closeDialog();
    enableTbButton('btnAdvanced', _enableTbButton);
    return result;
}

function publishOnStatusChange(status) {

    try {
        var publisher = gClassManager.getEventPublisher();
        var tag = publisher.getCallbackTag();
        publisher.publish(tag.onstatechange, status);
    }
    catch (e) {
    }
}

function publishClosingProject() {

    try {

        var publisher = gClassManager.getEventPublisher();
        var tag = publisher.getCallbackTag();
        publisher.publish(tag.onprojectselection);

    }
    catch (e) {
    }
}


function closeCurrentProject(bForce) {

    try {

        var AgentAssignment = gClassManager.getAgentAssignmentClass();
        var shareFrame = gClassManager.getSharedFrame();
        var closesentinel = gClassManager.getCloseSentinelFrame();
        if (typeof closesentinel != "object" || closesentinel == null )
        {
            info("closeCurrentProject>Not able to close intweb project because the close sentinel frame does not exist anymore...");
            return;
        }

    
        var result = closesentinel.IntWeb.Close( true );
        switch (result) {
            case "simulate":
                closesentinel.IntWeb.SimulateQuit(shareFrame.document);
                break;

            case "success":
            default:
                break;
        }

        AgentAssignment.setModuleName('');
        closesentinel.CallStats.Reset();
    }
    catch (e) {

        if (typeof closesentinel == "object" && typeof closesentinel.IntWeb == "object")
            closesentinel.IntWeb.Reset();

        error("closeCurrentProject> caught a java script exception when tryed to close intweb session -- reason: " + e.message);
    }

}


function NotifyProntoFromBtn(_btnId) 
{
    if (isPureCATI() == true) {
        return;
    }

    var Logger = gClassManager.getNewLogger() ;
    Logger._info('NotifyProntoFromBtn> button ' + _btnId + ' has been click');

    var closeSentinel = gClassManager.getCloseSentinelFrame();
    if ("btnWait" === _btnId) {

        var bNewAssignment = closeSentinel.AgentAssignment.Wait();
        if (bNewAssignment == false )
            toggleState(_btnId);

        return;
    }
    else if ("btnPause" === _btnId) {
        var userid = ReadUserId("NotifyProntoFromBtn", getTranslatedString("STR_INVALID_USERID"), false)
        closeSentinel.PAUSERequest.execute(userid);
        return;
    }
    else if ("btnHangup" === _btnId) {
        var properties = { onClick: hangupConfirmation, cancel: getTranslatedString("STR_Cancel") };
        DialogBox.showDialog(properties, getTranslatedString("STR_ConfirmHangup"));
        return;
    }
  
    return;
}
  
function hangupConfirmation( bConfirm ){

    if (typeof bConfirm != "boolean")
        return;

    if (bConfirm == false)
        return;

    try {
        var closeSentinel = gClassManager.getCloseSentinelFrame();
        var userid = ReadUserId("hangupConfirmation", getTranslatedString("STR_INVALID_USERID"), false)
        var line = closeSentinel.CallClass.Get("LINE");
        closeSentinel.HANGUPRequest.execute(userid, line, true);
    }
    catch (e) {
        error("hangupConfirmation> not able to execute hangup button -- exception: " + e.message);
    }

    return;
}

// Functions related to the management of Transfer_IVRMM with KEEP-AGENT
// Block the Interface (as much as possible when the user wait for a call to come back
function BlockInterfaceOnSuspend() {
    try {
        var _vTB = gClassManager.getToolbar();
        var _f0 = gClassManager.getCloseSentinelFrame();

        if (_vTB != null && _vTB != undefined && _vTB.enableTbButton != undefined)
            _vTB.enableTbButton('btnHangup', false);
    }
    catch (e) { };
}

// Unblock the Interface at the reception of resume
function UnblockInterfaceOnResume() {
    try {
        var _vTB = gClassManager.getToolbar();
        var _f0 = gClassManager.getCloseSentinelFrame();

        if (_vTB != null && _vTB != undefined && _vTB.enableTbButton != undefined)
            _vTB.enableTbButton('btnHangup', true);
    }
    catch (e) { };
}

// Call back method when the user come back from the TRANSFER_IVRMM
// The current question NO and Label are kept because the agent can navigate into
// the questionnaire during the transfer to the IVRMM script (Not Recommended, but the user can do it!)
function NotifyUserComeBackCB(_bOk, _wsCallWait) {
    trace('NotifyUserComeBackCB=' + _bOk);
    var _bErr = true;
    var _errMsg = null;
    var _ResumeQuestNo = '';
    var _ResumeQlabel = '';

    _lastCallWait = null;
    UnblockInterfaceOnResume();  // First thing unblock interface

    try {
        var _f1 = gClassManager.getToolbar();
        _f1.setLastCallResultMsg("");
    }
    catch (e) {
    }

    try {
        var _f0 = gClassManager.getCloseSentinelFrame();

        if (false === _bOk) {
            error('NotifyUserComeBackCB: Wait command failed. ' + _wsCallWait.getErrorMessage(), true);
            DialogBox.showAlert(getTranslatedString("STR_WAIT_FAILED"));
        }
        else if (arguments.length > 2) {
            var _vals = arguments[2].split(';');
            var _recNumb = 0;
            var _prontoCode = _KA_RESUME; // KeepAgent Resume; The Interview continue

            try {
                if (_f0 != null && _f0 != undefined) {
                    if (_f0._hiddens != null && _f0._hiddens != undefined) {
                        _ResumeQuestNo = _f0._ResumeQuestionNo; // Current Question No
                        _ResumeQlabel = _f0._ResumeQuestionLabel; // Current Question Label
                    }
                }
            }
            catch (e) {
            }


            if (_vals.length > 1)
                _recNumb = _vals[1];

            if (_recNumb != 0 && _f0 != null && _f0.SendACDTransferResultToIntWeb != undefined) {

                if (_vals[0] === "OK") {
                    if (_vals.length > 2) {
                        if (_vals[2] == 'DISCONNECT') _prontoCode = _KA_QUIT;  // KeepAgent Resume; KeepAgent Quit 
                        else if (_vals[2] == 'LOST') _prontoCode = _KA_LOST;  // KeepAgent Resume; KeepAgent Quit, Call Lost 
                        else _prontoCode = _KA_RESUME;
                    }
                    else _prontoCode = _KA_RESUME;

                    _f0.SendResponseToQuestion(_ResumeQlabel, _ResumeQuestNo, _prontoCode, true);
                }
                else {
                    _prontoCode = _KA_QUIT;
                    _f0.SendResponseToQuestion(_ResumeQlabel, _ResumeQuestNo, _prontoCode, true);
                }

                if ((getStatus() != _STATUS_INTERVIEW) && (_prontoCode == _KA_RESUME)) {	// Cancel wait because we switched to Pause
                    setTimeout('setStatus(' + _STATUS_INTERVIEW + ');', 500); // state is paused
                }
                else if (_prontoCode == _KA_QUIT || _prontoCode == _KA_LOST) { // Interview terminated go in wrap-up
                    setTimeout('setStatus(' + _STATUS_WRAPUP + ');', 500);
                    createPLCookie('Dialed', false, 1);
                }
            }
            else { // Recnumber not available ??? What to do ????
                f0.error('NotifyUserComeBackCB> The ivrmm transfer with keep agent option has no record number... The response frim proto is: ' +arguments[2]);
            }
        }
    }
    catch (e) {
         f0.error('NotifyUserComeBackCB> Caught a java script exception -- ' + e.message );
        _errMsg = 'NotifyUserComeBackCB;' + e.message;
        _bErr = true;
    }

    _wsCallWait = null;
    _waitInProcess = false;

}


// The user was transfer, the agent wait for the user to come back (KEEPAGENT Option)
function NotifyUserComeBack() {

    var _method = 'AgentResume';
    var _usedId = ReadUserId("NotifyUserComeBack", getTranslatedString("STR_INVALID_USERID"), false);
    if (null === _usedId) {

        error('NotifyUserComeBack> button [Wait] is cancelled. The user Id is not valid.', true);
        _waitInProcess = false;
        return false;
    }

    _wsCallPause = null;

    _wsCallWait = new WebServiceCall(this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx", 'AgentResumePolling');
    if (_wsCallWait != null) {
        _wsCallWait.setParams(new Array('_userId', _usedId, '_sessId', ''));

        // extract current question
        var _f0 = gClassManager.getCloseSentinelFrame();

        if (_f0 != null && _f0 != undefined) {
            if (_f0._hiddens != null && _f0._hiddens != undefined) {
                _ResumeQuestNo = _f0._hiddens.getItem('QUESTNO');
                _ResumeQlabel = _f0._hiddens.getItem('QLABEL');
            } 
        }
        if (null === _wsCallWait.getAjaxObj()) {
            DialogBox.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
            _wsCallWait = null;
            _lastCallWait = null;
            _waitInProcess = false;
            return (false);
        }
        else {
            _lastCallWait = _wsCallWait;
            trace('NotifyUserComeBack: Execute');
            _wsCallWait.execute(NotifyUserComeBackCB);
        }
    }
    return (true);

    }



function ActOnErrorNew(errorCode, cmd) {


    var toolBar = gClassManager.getToolbar();
    switch (errorCode) {
        case 'AGENT-LOGOUT-DIALER-DOWN':
            // Contact with dialer lost.  Must go back to Project selection .... ( pas bon )
            //  
            //  TODO
            //  Si l'agent est en entrevue nous devrions attendre la fin de l'entrevue..
            //  Utilisation ICRequest.setXXXXX pour signaler a l'interview complete que nous devons 
            //  retourner a la page de selection de projet.
            //  Pour le moment nous ne faisons rien contrairement a l'ancien code 
            //  qui retournait directement a la page de projet meme si l'entrevue etait en cour
            //
            setStatus(_STATUS_NOTSIGNEDON);
            DialogBox.showAlert(getTranslatedString(errorCode));
          
            error("ActOnErrorNew> Voxco.agent will return to project page -- " + errorCode);
            break;


        case 'AGENT-ACTIVE':

            var displayErr = true;
            if (toolBar.isTbButtonEnabled('btnWait') == true) {
                toolBar.enableTbButton('btnWait', false);
                displayErr = false;
            }
            if (toolBar.isTbButtonEnabled('btnPause') == false) {
                toolBar.enableTbButton('btnPause', true);
                displayErr = false;
            }

            if (displayErr == true)
                DialogBox.showAlert(getTranslatedString("STR_WAIT_FAILED"), false);

            break;

        case 'AGENT-NOT-SIGNED-ON':
        case 'PROJECT-NOT-ACTIVE':
        case 'PROJECT-CLOSE':
        case 'PROJECT-STOP':

            setStatus(_STATUS_NOTSIGNEDON);
            DialogBox.showAlert(getTranslatedString(errorCode), DialogBox.onClickProjectError);
            error("ActOnErrorNew> The project has been stopped. Voxco.agent will return into the project page -- reason: " + errorCode);
            break;


        case "404":
            break;

        case 'RECORD_FAILED':
        case 'OPENED_FAILED':
        case 'PLAY_FAILED':
        case 'PROJECT-NOT-ACTIVE':
        case 'EXTENSION-NOT-SIGNED-ON':
        case 'REMOTE-MODULE-NOT-ACTIVE':
        case 'WKS-NOT-ACTIVE':
        case 'AGENT-NOT-IN-CALL':
        case 'NO-LINE-TO-DIAL-OUT-REMOTE-AGENT':
        case 'COMMAND-DENIED-AT-THIS-TIME':
        case 'CANNOT-LOGIN-PROJECT':
        case 'PRONTOSERVER-UNREACHABLE':
        default:

            DialogBox.showAlert(getTranslatedString(errorCode));
            break;
    }
            }
            
function isPureCATI() {

    var _isPureCATI = false;
    try {
        var ProjectAssignment = gClassManager.getAgentAssignmentClass();
        if (ProjectAssignment != null && ProjectAssignment != undefined && typeof (ProjectAssignment.isCatiOnly) == 'function') {
            _isPureCATI = ProjectAssignment.isCatiOnly();
        }
        else {
            Logger._warning('ProjectAssignment object is not available !');
        }
        if (_isPureCATI == true)
            ProntoPageType = _MODULE_UNDEF;
    }
    catch (e) {
        Logger._error("PH_Script - isPureCATI> not able to determine if the project is cati only or cati with a telephony module. We caugth a java script exception -- " + e.message);
        Logger._error(new Error().stack);
    }

    return _isPureCATI;
}

function notifyServerBtnState(_btnId, _bSet) 
{
    if (_btnId != undefined && _bSet != undefined) {
        gClassManager.getButtonClass().toggleButton(_btnId, _bSet);
    }
}

function toggleState(_btnId, _reset) 
{
    trace('toggleState(' + _btnId + ')');
    var _withReset = true;
    if (_reset != undefined) {
        _withReset = _reset;
    }

    var result = gClassManager.getButtonClass().toggleButton(_btnId, _reset);
    setBtnFromStatus(result, _withReset, _btnId);
}

function typeOfWaitAnswer(_answer)
{
    var _retVal = '';
    if (0 ===_answer.indexOf('OK'))
    {
        _retVal = 'OK';
    }
    else if (0 === _answer.indexOf('ERR'))
    {
        _retVal = 'ERR';
    }
    else if (0 === _answer.indexOf('CANCEL'))
    {
        _retVal = 'CANCEL';
    }
    else
    {
        _retVal = 'ERR';
    }
    
    return _retVal;
}

function gotWaitAnswer( Request ) {


    //US1228
    _phoneNoSaved = "";
    //US1228

    ResetBeginCallVariables(true);

    var Logger = gClassManager.getNewLogger() ;
    var closeSentinelFrame = gClassManager.getCloseSentinelFrame();
    var toolBar = gClassManager.getToolbar();

    var _recno = Request.getParameter("recordid");
    var _lookup = Request.getBoolParameter('LOOKUP');
    var _dialingMode = Request.getParameter('DIALING-MODE');
    var _projectName = Request.getParameter('PROJECT-NAME');
    var _ani = Request.getParameter('ANI');
    var _dnis = Request.getParameter('DNIS');
    var _catiPid = Request.getParameter('CATI');
    var _sessionguid = Request.getParameter('SESSION-GUID');
    var _lineNo = Request.getParameter('LINE');
    var _mode = Request.getParameter('MODE');

    var _projectName = Request.getParameter('PROJECT-NAME');
    var _parametersList = Request.getParameterListName();
    var _parametersValues = Request.getParameterListValue();

    createPLCookie('RecNum', _recno, 1);



    if (_lineNo.length != 0) {
        closeSentinelFrame.setLineNo(_lineNo);
        toolBar.setNewCall("0", _lineNo);
    }

    if (toolBar.getAdvancedMode() === "1")
        toolBar.setAdvancedMode("0");

    var _gotRecord = _ANSWER_INCALL;
    var _newUrl = "";
    var _dialingproject = "automatic";

    switch (_mode) {
        case 'I':

            _newurl = closeSentinelFrame.getNewCallInboundUrl(_recno, _dialingMode, _catiPid, _sessionguid, _lookup, _ani, _dnis, _parametersList, _parametersValues);
            if (_newurl.length > 0) {
                ConsoleDebug._debug("Inbound intweb url: " +_newurl);
                Logger._info("gotWaitAnswer> Inbound call has been received. Invoking intweb service to display the first page");
                setTimeout("setIntWebUrl('" + _newurl + "');", 1);
            }
            else {
                Logger._error("gotWaitAnswer> received an inbound call but we are not able to determine the intweb url");
                _gotRecord = _ANSWER_NOINTWEBURL;
            }

            break;

        case 'P':

            ConsoleDebug._debug("received a preview record. Must be from an hybrid module our manual dialer... record id: " + _recno);

            _dialingMode = 0;
            _dialingproject = "preview";
            _gotRecord = _ANSWER_NOTINCALL;

        case 'O':
        default:

            
            _newurl = closeSentinelFrame.getNewCallUrl(_recno, _dialingMode);

            ConsoleDebug._debug("Outbound intweb url: " +_newurl);
            Logger._info("gotWaitAnswer> Oubound call has been received. Invoking inweb service to display the first page by calling setIntWebUrl callback function -- dialing project : " + _dialingproject, true);
            setTimeout("setIntWebUrl('" + _newurl + "');", 1);
            break;
    }

    return (_gotRecord);
}


function SavePreference(preference) {
    if (preference != null && preference !== '' && _oldPrefValues != preference) {

        var additionnalSetting = {};
        additionnalSetting.async = false;


        iCommon.callServerMethod("VerticalTb.aspx", "SetPreferencesJSON", {_prefs: preference }, function (result) { }, function (xhr, msg, e) { }, additionnalSetting);

        var mainFrame = gClassManager.getMainFrame();
        if (mainFrame != undefined) {
            // Apply changes to the current session
            if (preference.ShowLogo !== _oldPrefValues.ShowLogo) {
                // Logo changed
                mainFrame.showLogo(preference.ShowLogo);
            }
            if (preference.AgentLanguage !== _oldPrefValues.AgentLanguage) {
                // Language changed
                if (_STATUS_NOTSIGNEDON === getStatus()) {
                    // Reload mainframe
                    mainFrame.reloadMainFrame();

                    // Reload toolbar
                    mainFrame.reloadToolbarFrame();

                    // Reload footer
                    mainFrame.reloadFooterFrame();
                }
            }
        }
    }
}

function PrefDlgBox() {
    var _win = null;
    _oldPrefValues = "";

    var additionnalSetting = {};
    additionnalSetting.async = false;

    iCommon.callServerMethod("VerticalTb.aspx", "GetPreferencesJSON", null, function (result) {
        if (result.d != null) {
            var preference = JSON.parse(result.d);
            _oldPrefValues = preference;
            enableTbButton('btnPref', false);
            enableTbButton('btnProjects', false);

            showPreferenceModal(preference);
        }
    }, function (xhr, msg, e) { }, additionnalSetting);
}

function onPasswordChg() {
    // Get salt value
    var additionnalSetting = {};
    additionnalSetting.async = false;
    var salt = "";
    iCommon.callServerMethod("ChgPwdPref.aspx", "GetRandom", null, function (result) { salt = result.d }, function (xhr, msg, e) { }, additionnalSetting);

    var sharedFrame = gClassManager.getSharedFrame();
    if (sharedFrame !== undefined) {
        sharedFrame.salt = salt;
        var changePasswdDialog = $('#chgPass', sharedFrame.document)[0];
        if (changePasswdDialog !== undefined) {
            $('#passwdChangeErrMsg', changePasswdDialog).text('');
            var curPasswd = $('#currentPasswd', changePasswdDialog);
            if (curPasswd !== undefined) curPasswd.val('');

            var newPasswd = $('#newPasswd', changePasswdDialog);
            if (newPasswd !== undefined) newPasswd.val('');

            var confPasswd = $('#confirmPasswd', changePasswdDialog);
            if (confPasswd !== undefined) confPasswd.val('');

            changePasswdDialog.style.display = "block";
        }
    }
}
function onClosePasswordDialog() {
    var sharedFrame = gClassManager.getSharedFrame();
    if (sharedFrame !== undefined) {
        var changePasswdDialog = $('#chgPass', sharedFrame.document)[0];
        if (changePasswdDialog !== undefined) {
            changePasswdDialog.style.display = "none";
        }
    }
}
function changePasswdDialogInputKeyUp(evt) {
    if (13 == evt.keyCode) onSavePassword();
}

function onSavePassword() {
    var curPasswdValue = "",
        newPasswdValue = "",
        confPasswdValue = "";

    var sharedFrame = gClassManager.getSharedFrame();
    if (sharedFrame !== undefined) {
        var changePasswdDialog = $('#chgPass', sharedFrame.document)[0];
        if (changePasswdDialog !== undefined) {
            // Get the current password
            var curPasswd = $('#currentPasswd', changePasswdDialog);
            if (curPasswd !== undefined) {
                curPasswdValue = curPasswd.prop('value');
    }

            // Get the new password
            var newPasswd = $('#newPasswd', changePasswdDialog);
            if (newPasswd !== undefined) {
                newPasswdValue = newPasswd.prop('value');
            }

            // Get the confirmation password
            var confPasswd = $('#confirmPasswd', changePasswdDialog);
            if (confPasswd !== undefined) {
                confPasswdValue = confPasswd.prop('value');
            }

            var password = {};
            password.salt = sharedFrame.salt;
            password.pwd = xor(password.salt + newPasswdValue);
            password.currentPwd = xor(password.salt + curPasswdValue);

            // Do change passwd
            if (checkPwd(newPasswdValue, confPasswdValue, changePasswdDialog)) {
                $('#passwdChangeErrMsg', changePasswdDialog).text('');
                var additionnalSetting = {};
                additionnalSetting.async = false;

                iCommon.callServerMethod("ChgPwdPref.aspx", "ChangePwd", { _password: password },
                    function (result) {
                        if (result.d != undefined && result.d != null && result.d.length != 0) {
                            $('#passwdChangeErrMsg', changePasswdDialog).text(result.d);
    }
    else {
                            changePasswdDialog.style.display = "none";
    }
                    },
                    function (xhr, msg, e) { },
                    additionnalSetting);
            }
        }
    }
}
function checkPwd(newPasswd, confirmPasswd, changePasswdDialog) {
    if (newPasswd != confirmPasswd) {
        $('#passwdChangeErrMsg', changePasswdDialog).text(getResource("##PH_ErrConfirmPwd##"));
            return (false);
    }
    return (true);
}
function getResource(resource) {
    var additionnalSetting = {};
    additionnalSetting.async = false;
    var strResource = "";
    iCommon.callServerMethod("ChgPwdPref.aspx", "GetResource", { "resource": resource }, function (result) { strResource = result.d }, function (xhr, msg, e) { }, additionnalSetting);
    return strResource;
    }

function showPreferenceModal(preference) {
    var sharedFrame = gClassManager.getSharedFrame();
    if (sharedFrame !== undefined) {
        sharedFrame._oldPrefValues = preference;
        var prefDialog = $('#pref', sharedFrame.document)[0];
        if (prefDialog !== undefined) {

            // Init language dropdown
            var selLang = $('#selLang', prefDialog);
            selLang.empty();
            for (var i = 0, len = preference.AvailableLanguages.length; i < len; i += 1) {
                var currentLang = preference.AvailableLanguages[i];
                if (currentLang.Lang === preference.AgentLanguage) {
                    selLang.append($("<option>").attr('value', currentLang.Lang).attr('selected', 'selected').text(currentLang.Text));
                }
                else {
                    selLang.append($("<option>").attr('value', currentLang.Lang).text(currentLang.Text));
                }
            }

            // Init the Show Logo checkbox
            var prefShowLogo = $('#chkLogo', prefDialog);
            if (prefShowLogo !== undefined) {
                prefShowLogo.prop('checked', preference.ShowLogo);
            }

            prefDialog.style.display = "block";
        }
    }
}

function closeDialog() {
    var sharedFrame = gClassManager.getSharedFrame();
    var prefDialog = $('#pref', sharedFrame.document)[0];
    if (prefDialog !== undefined) {
    enableTbButton('btnPref', true);
    enableTbButton('btnProjects', true);

        prefDialog.style.display = "none";
}
}

function onSavePreference() {
    var isPreferenceChanged = false;

    var sharedFrame = gClassManager.getSharedFrame();
    if (sharedFrame !== undefined) {
        var prefDialog = $('#pref', sharedFrame.document)[0];
        if (prefDialog !== undefined) {
            // Get the selected language
            var selLang = $('#selLang option:selected', prefDialog);
            if (selLang !== undefined) {
                var selLangValue = selLang.prop('value');
                if (selLangValue !== _oldPrefValues.AgentLanguage) {
                    isPreferenceChanged = true;
            }
        }

            // Get the show logo checkbox
            var prefShowLogo = $('#chkLogo', prefDialog);
            if (prefShowLogo !== undefined) {
                var isShowLogoChecked = prefShowLogo.prop('checked');
                if (isShowLogoChecked !== _oldPrefValues.ShowLogo) {
                    isPreferenceChanged = true;
                }
            }

            // Save preference
            if (isPreferenceChanged) {
                var changedPref = $.extend(true, {}, _oldPrefValues);
                changedPref.AgentLanguage = selLangValue;
                changedPref.ShowLogo = isShowLogoChecked;
                SavePreference(changedPref)
            }

            enableTbButton('btnPref', true);
            enableTbButton('btnProjects', true);

            prefDialog.style.display = "none";
        }
    }
}
  
function getTimerValue(_start) 
{
    if (null === _start) { return ""; }
    var now = new Date();
    var _diff = now - _start; // Nb Ms
    _diff /= 1000;
    var _h = Math.floor(_diff / 3600);
    _diff -= _h * 3600;
    var _m = Math.floor(_diff / 60);
    _diff -= _m * 60;
    var _s = Math.round(_diff);
    if (_s > 59) {
        _s = 59; // Rounding pb
    }
    while (_h >= 24) {
        _h -= 24;
    }

    var _str = '';
    if (_h < 10) {_str = '0';}
    _str += _h + ':';
    if (_m < 10) { _str += '0';}
    _str += _m + ':';
    if (_s < 10) {_str += '0';}
    _str += _s;
    return (_str);
}

function createPLCookie(name, value, days) 
{
    var expires = "";
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = "; expires=" + date.toGMTString();
    }
    document.cookie = name + "=" + value + expires + "; path=/";
}

function erasePLCookie(name) 
{
    createPLCookie(name, "", -1);
}

function readPLCookie(name) 
{
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') {
            c = c.substring(1, c.length);
        }
        if (c.indexOf(nameEQ) === 0) {
            return c.substring(nameEQ.length, c.length);
        }
    }
    return null;
}

function InitIntWebPage() 
{
    _hiddens = new Hash();
}

function ExamineIntWebPage(_doc) 
{
    InitIntWebPage();

    ConsoleDebug._debug("ExamineIntWebPage> The intweb url: " + _doc.location);
    var intwebFrame = gClassManager.getSharedFrame();

    var _key    = "";
    var _value  = "";
    var i = 0;
    try
    {
        var _inputs = _doc.getElementsByTagName("input");
        for (i = 0; i < _inputs.length; i++) 
        {
            if (_inputs[i].type.toUpperCase() === "HIDDEN") 
            {
                // For example
                //<INPUT TYPE="HIDDEN" NAME="CMDCOUNT" VALUE="1">
                //<INPUT TYPE="HIDDEN" NAME="CMD1" VALUE="DIAL">
                //<INPUT TYPE="HIDDEN" NAME="CMD1_PHONENO" VALUE="">

                if (_inputs[i].name == 'DATETIME')
                    ConsoleDebug._info("ExamineIntWebPage> reading hidden variable DATETIME ....  " + _inputs[i].value);

                if (_inputs[i].name != '') 
                {
                    if (_inputs[i].value == "INT_COMPLETE")
                    {

                        ICRequest.setMaskFound(true);
                        var bNewAssignment = AgentAssignment.GetNewCatiProjectAssignment();
                        
                    }

                    _key    = _inputs[i].name.toUpperCase();
                    _value  = _inputs[i].value;

                    _hiddens.setItem(_key, _value);
                }
            }
        }

    }
    catch( e )
    {
        error("ExamineIntWebPage> caught a java script exception when reading pronto MASK. Exception: " + e.Message + "... last key: " + _key + " -- last value: " + _value + "-- last index: " +  i);
    }
   

    try 
    {
        //
        //  On s'assure que l'interview complete est present dans la page . Dans certain cas les Intweb ne genere pas la page de 
        //  callback correctement et si l'interview complete n'est pas present voxco.agent ne revient pas sur ces pattes et voxcobrige
        //  ne reviennent pas sur leurs pattes correctements
        //

        gClassManager.getPingClass().Set();
        var threadid = gClassManager.getConfigManager().SetThreadId(_hiddens);
        if( threadid != null )
            debug("ExamineIntWebPage> the intweb connection thread id for this session is " + threadid);

        var _webcati = getWebCati();
        if (_webcati != null && _webcati.SEARCHFIELD != null) {

            if (isPureCATI() == true )
                enableIntWebCtrl(intwebFrame, NewCallBtnId, true); // NewCall
                      
            ProntoCmdManager.clearCmd();
            if (ICRequest.isMaskFound() == false && CallStats.isCallReceived() == false) {
                info("ExamineIntWebPage> The agent just started his intweb session");
                return;
            }


          

            var ierror = _hiddens.getItem("IERROR", 0);
            if (ICRequest.isMaskFound() == true)
                info("ExamineIntWebPage> found an interview complete in the intweb callback page... IERROR: " +  ierror);

            ICRequest.GenerateInterviewComplete(ProntoCmdManager);
        }
    }
    catch( e )
    {
        error("ExamineIntWebPage> caugth java script exception when trying to extract mask -- exception " +  e.Message );
    }
   
}

function CookieReadUserId() {

    var _retVal = null;
    var _name = 'PH_LoginInfo'; // User info tag 
    var _ck = document.cookie;
    if (_ck != null && _ck.length > 0) {
        var _p = _ck.indexOf(_name + '=');
        if (_p != -1) {
            _p += _name.length + 1;
            var _pend = _ck.indexOf(";", _p);
            if (_pend === -1) {
                _pend = _ck.length;
            }
            var _spl = unescape(_ck.substring(_p, _pend)).split(","); // wk,rem,ctx,id
            if (4 === _spl.length) {
                _retVal = _spl[3];
            }
        }
    }

    return (_retVal);
}

function ReadUserId( command, message, bExpectedfiche ) 
{
    var userid = null;
    try {

        userid = gClassManager.getConfigManager().getUserId();
    }
    catch (e) {
        error("ReadUserId> Not agent able to get the agent user id for " + command + "User id is need it to send and dispatch request to telephony server");
        DialogBox.showAlert(message);
    }

    
    return userid ;
}

function setIntWebUrl(_url) 
{
    if (_url != undefined && _url != null) {
        var _f2 = gClassManager.getSharedFrame();

        if (_f2 != null) {
            debug("setIntWebUrl> The intweb page should be display by setting location.href to url  " + _url );
            _f2.location.href = _url;
        }
        else {
            error("setIntWebUrl> Not able to display intweb url" + _url + ". Intweb frame does not exist anymore." );
        }
    }
    else {
        error("setIntWebUrl> Not able to display intweb page because the url request is not defined.");
    }
}

function IsWaiting() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.IsWaitingState != undefined) {
        return _f0.IsWaitingState();
    }
    return false;
}

function IsPaused() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.IsPausedState != undefined) {
        return _f0.IsPausedState();
    }
    return false;
}

function IsLastCall() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.IsLastCallState != undefined) {
        return _f0.IsLastCallState();
    }
    return false;
}

function InInterview() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.InInterviewState != undefined) {
        return _f0.InInterviewState();
    }
    return false;
}

function expectInterview(_inCall) 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.StartExpectInterview != undefined) {
        return _f0.StartExpectInterview(_inCall);
    }
    return false;
}

function afterVATBLoaded() 
{
    // To review for stack overflow
    // Notify Closed sentinel
    try 
    {
        var _f0 = gClassManager.getCloseSentinelFrame();
        if (_f0 != null && _f0 != undefined && _f0.afterTBLoaded != undefined) {
            _f0.afterTBLoaded();
        }
    }
    catch (e) {
        error("afterVATBLoaded> caugth an javascript -- exception: " + e.message, true);
    }
}

function refreshStatus()
{
    displayStatus(getStatus());
    gTimer.Reset(getStatus());
}


function displayStatus(_status) 
{
    var _f1 = gClassManager.getToolbar();
    if (_f1 != undefined && _f1.displayTextStatus != undefined) {
        _f1.displayTextStatus(_status); // For resource translation
    }

    var _img = document.getElementById('statusImg');
    var _cnt = document.getElementById('statusCnt');

    if (_STATUS_SIGNEDON === _status) {
        // Signed on
		if (_cnt!=null) {_cnt.innerHTML="";}
		if (_img!=null) {_img.style.display="inline";}
		if (_img!=null) {_img.src="./Images/ico16_accept.gif";}
		enableTbButton('btnProjects',true);
    } 
    else if (_STATUS_WAITING === _status) {
        // Waiting
        enableTbButton('btnProjects', false);
        _img.style.display = "inline";
        _img.src = "./Images/ico16_Wait.gif";
    } 
    else if (_STATUS_PAUSED === _status) {
        // Paused
        if (_img != null) {
            _img.style.display = "inline";
            _img.src = "./Images/ico16_pause.gif";
        }
    } 
    else if (_STATUS_INTERVIEW === _status) {
        // Interview
        if (_img != null) {
            _img.style.display = "inline";
            _img.src = "./Images/ico16_interviewer.gif";
        }
    } 
    else if (_STATUS_WRAPUP === _status) {
        // Wrapup
        if (_img != null) {
            _img.style.display = "inline";
            _img.src = "./Images/ico16_groupclosed.gif";
        }
    } 
    else {
        // defaulr
        if (_cnt != null) {_cnt.innerHTML = "";}
        if (_img != null) {_img.style.display = 'none';}
    }
}

function changeStatus(_status)
{
    displayStatus(_status);
    restartCounterTimer();
}

function restartCounterTimer()
{
    gTimer.Reset();
    return;
}

function setStatus(_status) 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.setAppStatus != undefined) {
        _f0.setAppStatus(_status);
    }
}

function getStatus() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.getAppStatus != undefined) {
        return (_f0.getAppStatus());
    }
    return (0);
}

function isInPausedDelay() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.isInPausedDelay != undefined) {
        return (_f0.isInPausedDelay());
    }
    return (false);
}

function expectFiche() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != null && _f0.expectFiche != undefined) {
        return (_f0.expectFiche());
    }
    return (false);
}


function trimString(_inStr) 
{
    return _inStr.replace(/^\s*/, "").replace(/\s*$/, "");
}


   

function setRecording(_set)
{
    _isRecording = _set ;
    var _f1 = gClassManager.getToolbar();

    if (_f1 != null && _f1.showRecording != undefined) {

        _f1.showRecording(_set);
    }

}

function setPlaying(_set) 
{
    if (_isPlaying != _set) {
        _isPlaying = _set;
    }
    var _f1 = gClassManager.getToolbar();
    if (_f1 != null && _f1.showPlaying != undefined) {
        _f1.showPlaying(_set);
    }
}

function setPlayingRecording(_set) 
{
    if (_isPlaying != _isRecording) {
        setPlaying(_set);
        setRecording(_set);
    } 
    else {
        if (_isPlaying != _set) {
            _isPlaying = _set;
            _isRecording = _set;
        }
        var _f1 = gClassManager.getToolbar();
        if (_f1 != null && _f1.showPlaying != undefined) {_f1.showPlaying(_set);}
        if (_f1 != null && _f1.showRecording != undefined) {_f1.showRecording(_set);}
    }
}

function urlEncode(_url) 
{
    return escape(_utf8_encode(_url));
}

function _utf8_encode(string) 
{
    string = string.replace(/\r\n/g, "\n");
    var utftext = "";
    for (var n = 0; n < string.length; n++) 
    {
        var c = string.charCodeAt(n);
        if (c < 128) {
            utftext += String.fromCharCode(c);
        } 
        else if ((c > 127) && (c < 2048)) {
            utftext += String.fromCharCode((c >> 6) | 192);
            utftext += String.fromCharCode((c & 63) | 128);
        } 
        else {
            utftext += String.fromCharCode((c >> 12) | 224);
            utftext += String.fromCharCode(((c >> 6) & 63) | 128);
            utftext += String.fromCharCode((c & 63) | 128);
        }
    }
    return utftext;
}


function HelpWindow() {
    var lang = "en";
    if (_currentLanguage != undefined) {
        lang = _currentLanguage;
    }


    var url = "./help/" + lang + "/default.htm";
    var http = new XMLHttpRequest();
    http.open('HEAD', url, false);
    http.send();
    if (http.status != 404) {
        window.open(url);
    }
    else {
        console.log("Voxco Agent Help is not installed");
    }
}

function clientAlert(_msg, _expectedFiche, onClickcallback) 
{
    //----------------------------------------------------------------------
    // Description:  function clientAlert
    // Parameters:
    //    _msg           : message to display to the user
    //    _expectedFiche : flag that tell us to bypass the record check.
    //----------------------------------------------------------------------  


    if (_msg == undefined || _msg == null || _msg.length == 0 ) {
        return;
    }

    error('alert> ' + _msg);

    //
    //  Fonction a retravaillé
    //
    //  1) Les alertes sont affichées si seulement si nous elles sont activées par le 
    //     fichier app.config
    //  2) Certaines alertes devraient etre affiche meme si la configuration indique 
    //     le contraire comme par exemple remote-agent-disconnect et les erreurs de intweb ( 2009 )
    //
    //  getShouldDisplayAlerts() a quoi ca sert
    //
    //  Pour le moment si un callback ( onClickcallback ) est defini , nous considerons l'alert prioritaire
    //  on nous ne tenons pas compte du restant de la poutine.
    //  
    //  
    if (typeof onClickcallback == "function") {
        gClassManager.getDialogObject().showAlert(_msg, onClickcallback);
        return;
    }

 
    if (_displayAlert == null) {
        _displayAlert = true;
        var _ConfigClass = gClassManager.getConfigManager();
        if (_ConfigClass != undefined) {
            _displayAlert = _ConfigClass.getDisplayAlert();
            if (_displayAlert == true)
                info('alert> all display alert will be displayed on agent screen');
			else 
                info('alert> no display alert will be diplayed on the agent screen');
        }
    }

    if (_displayAlert == true )
    {
        if (_expectedFiche == true) {
            // verify if there is no incoming record. 
            // If so, retry later.
            if (expectFiche()) {
                setTimeout(function() { clientAlert(_msg,true); }, 1000);
                return;
            }
        }
        
        gClassManager.getDialogObject().showAlert(_msg, onClickcallback);
    }
}

function getTranslatedString(_key) 
{
    var _f1 = gClassManager.getToolbar();
    if (_f1 != null && undefined != _f1.getVAResourceValue) {return (_f1.getVAResourceValue(_key));}
    return ("");
}

function logMsgX(_msg) {
    jsWriteInfoTolog(_msg);
}


function pollWaitExplicit() 
{
    var userid = AgentAssignment.getUserId() ;
    WAITRequest.execute(userid);
}

function noContextMenuVoxcoAgent(evt) 
{
    try {
        if (window.Event && evt) {
            evt.cancelBubble = true;
        } 
        else {
            event.cancelBubble = true;
            event.returnValue = false;
        }
        return false;
    }
    catch (_e) { 
    }
}

function ShowAgentMsg() {
    //_winAgMsg=null;
    var _usragt = this.navigator.userAgent.toLowerCase();
    var _w = 820;
    var _h = 500;
    var _param = '';
    var _win = null;
    var _opt = "";


    var _f0 = gClassManager.getCloseSentinelFrame();

    if (_f0 !== null && _f0.getMessagingWindow != undefined) _win = _f0.getMessagingWindow();
    if (_win !== null) _win.close(); // close existing AgentMailBox.aspx
    if (_usragt.indexOf("msie") != -1) _opt = "dialogWidth: " + _w + "px; dialogHeight: " + _h + "px; resizable: no;";
    else {
        var _t = (screen.height / 2) - (_h / 2);
        var _l = (screen.width / 2) - (_w / 2);
        _opt = "dialogWidth: " + _w + "px; dialogHeight: " + _h + "px; dialogTop: " + _t + "px; dialogLeft: " + _l + ";resizable: yes";
    }

    var _date = new Date();

    var _usedId = ReadUserId("ShowAgentMsg", null, false);
    if (_usedId !== null) _param = "?fromId=" + _usedId + '&rt=' + _date.getTime(); // Force a new url so a new page fetched from the server
    else _param = '?rt=' + _date.getTime(); // Force a new url so a new page fetched from the server

    if (window.showModalDialog) _win = window.showModalDialog("./AgentMailBox.aspx" + _param, "Agmsgwin", _opt);
    else _win = window.open("./AgentMailBox.aspx" + _param, "Agmsgwin", "center=yes, modal=yes,resizable=0,location=0,status=0,menubar=0,width=" + _w + ",height=" + _h);
}

function norightclickVoxcoAgent(evt) 
{
    if (window.Event && evt) {
        if (evt.which != 1) return false;
    } 
    else if (event.button != 1) {
        event.cancelBubble = true
        event.returnValue = false;
        return false;
    }
}

function jsWriteInfoTolog(msgTowrite) {

    var Logger = gClassManager.getNewLogger();
    if (typeof Logger != "object")
        return;

    Logger._trace(msgTowrite);
    return;
}

function byPassCtrlCode(keycode) 
{
    //Keys: e,f,h,i,j,k,l,n,o,r,t,w, and F4 key (code 115)
    var _ctrlCodesList = [69, 70, 72, 73, 74, 75, 76, 78, 79, 82, 84, 87, 115];
    var _codeTofind = 0;

    if (keycode == 0) 
    {
        return true;
    }


    if (keycode == 115) 
    {
        //ctrl-F4 code
        return true;
    } 
    else 
    {
        var keyname = String.fromCharCode(keycode);
        var upperKeyname = keyname.toUpperCase();
        if (keyname !== upperKeyname) 
        {
            _codeTofind = upperKeyname.charCodeAt(0);
        } 
        else 
        {
            _codeTofind = keycode;
        }

        for (var i = 0; i < _ctrlCodesList.length; i++) 
        {
            if (_codeTofind == _ctrlCodesList[i]) 
            {
                return true;
            }
        }
    }
    return false;
}

function byPassSingleCode(keycode) 
{
    //keys: Backspace, Escape, F5, F6, F11
    var _singleCodesList = [8, 27, 116, 117, 122];
    var _singleKeysNameList = ['BackSpace', 'ESC', 'F5', 'F6', 'F11'];


    //
    //  Dans le doute on le laisse passe ) DE
    //
    if (keycode == 0) {
        return false;
    }


    for (var i = 0; i < _singleCodesList.length; i++) 
    {
        if (keycode == _singleCodesList[i]) 
        {
            return true;
        }
    }
    return false;
    }

function byPassSourceElement(srcElement) {

    if (srcElement !== undefined) {
        if (srcElement.type !== undefined && srcElement.type === "search") {
    return false;
}
    }
    return true;
}

function getVASingleKeyName(keycode) 
{
    //keys: Backspace, Escape, F5, F6, F11
    var _singleCodesList = [8, 27, 116, 117, 122];
    var _singleKeysNameList = ['BackSpace', 'ESC', 'F5', 'F6', 'F11'];

    var _keyname = null;


    for (var i = 0; i < _singleCodesList.length; i++) 
    {
        if (keycode == _singleCodesList[i]) 
        {
            _keyname = _singleKeysNameList[i];
            break;
        }
    }
    return _keyname;
}

function byPassAltCode(keycode) 
{
    //keys: Home, <-, ->
    var _altCodesList = [36, 37, 39, 115];
    var _altKeysNameList = ['Home', 'Left', 'Right', 'F4'];

    if (keycode == 0) 
    {
        return true;
    }

    for (var i = 0; i < _altCodesList.length; i++) 
    {
        if (keycode == _altCodesList[i]) 
        {
            return true;
        }
    }
    return false;
}

function getVAAltKeyName(keycode) 
{
    //keys: Home, <-, ->
    var _altCodesList = [36, 37, 39, 115];
    var _altKeysNameList = ['Home', 'Left', 'Right', 'F4'];
    var _keyname = null;


    for (var i = 0; i < _altCodesList.length; i++) 
    {
        if (keycode == _altCodesList[i]) 
        {
            keyname = _altKeysNameList[i];
            break;
        }
    }
    return keyname;
}

function getVACtrlKeyName(keycode) 
{
    //Keys: e,f,h,i,j,k,l,n,o,r,t,w, and F4 key (code 115)
    var _ctrlCodesList = [69, 70, 72, 73, 74, 75, 76, 78, 79, 82, 84, 87, 115];

    var keyname = null;

    switch (keycode) 
    {
    case 115:
        keyname = 'F4';
        break;
    case 69:
    case 70:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 78:
    case 79:
    case 82:
    case 84:
    case 87:
        keyname = String.fromCharCode(keycode);
        break;
    }

    return keyname;
}

function onKeyDownVoxcoAgent(e) 
{
    if (window.event) 
    {
        var keycode = window.event.keyCode;
        if (window.event.ctrlKey == true) 
        {
            var retcode = byPassCtrlCode(keycode);
            if (retcode == true) 
            {
                event.cancelBubble = true;
                window.event.keyCode = 0;
                event.returnValue = false;
            }
        } 
        else if (window.event.altKey == true) 
        {
            var retcode = byPassAltCode(keycode);
            if (retcode == true) {
                if (keycode == 115) {
                    //ALT-F4 key was pressed
                    //Write to log here because there is no KeyUp event for ALT-F4
                    var _f0 = gClassManager.getCloseSentinelFrame();

                    if (_f0 != null && _f0 != undefined) {
                        if (_f0.altF4KeyPressed != undefined) {
                            _f0.altF4KeyPressed = true;
                        }

                        _f0.Logger._debug("onKeyDownVoxcoAgent> button [ALT-F4] is pressed on keyboard.");
                    }
                } 
                else {
                    event.cancelBubble = true;
                    window.event.keyCode = 0;
                    event.returnValue = false;
                }
            }
        } 
        else 
        {
            var retcode = byPassSingleCode(keycode);
            var isElementToBypass = byPassSourceElement(window.event.srcElement); // Do not bypass some element
            if (retcode === true && isElementToBypass)
            {
                event.cancelBubble = true;
                window.event.keyCode = 0;
                event.returnValue = false;
            }
        }
    } 
    else if (e) 
    {
        //------------------------------------------------------------
        // When the Browser is Firefox, stop the propagation then 
        // call the onKeyPress  event handler to do the job.
        ///-----------------------------------------------------------
        if (e.ctrlKey == true) 
        {
            var retcode = byPassCtrlCode(e.which);
            if (retcode == true) 
            {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
        } 
        else if (e.altKey == true) 
        {
            var retcode = byPassAltCode(e.which);
            if (retcode == true) {
                if (e.which == 115) {
                    //ALT-F4 key was pressed
                    //Write to log here because there is no KeyUp event for ALT-F4
                    var _f0 = gClassManager.getCloseSentinelFrame();
                    if (_f0 != null && _f0 != undefined) {
                        if (_f0.altF4KeyPressed != undefined) {
                            _f0.altF4KeyPressed = true;
                        }

                        _f0.Logger._debug("onKeyDownVoxcoAgent> button [ALT-F4] is pressed on keyboard.");
                    }
                } 
                else {
                    e.preventDefault();
                    e.stopPropagation();
                    return false;
                }
            }
        } 
        else 
        {
            var retcode = byPassSingleCode(e.which);
            var isElementToBypass = byPassSourceElement(window.event.srcElement); // Do not bypass some element
            if (retcode === true && isElementToBypass)
            {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
        }
    }
}

function onKeyPressVoxcoAgent(e) 
{
    if (e) 
    {
        var keycode = e.which;
        if (e.ctrlKey == true) 
        {
            var retcode = byPassCtrlCode(keycode);
            if (retcode == true) 
            {
                e.stopPropagation();
                e.preventDefault();
                return false;
            }
        } 
        else if (e.altKey == true) 
        {
            var ret = byPassAltCode(keycode);
            if (ret == true) 
            {
                e.stopPropagation();
                e.preventDefault();
                return false;
            }
        }
    }
}

function onKeyUpVoxcoAgent(e) 
{
    var keycode = 0;
    var isCtrlKey = false;
    var isAltKey = false;

    if (window.event) 
    {
    
        keycode = window.event.keyCode;
        isCtrlKey = window.event.ctrlKey;
        isAltKey = window.event.altKey;
    } 
    else if (e) 
    {
        keycode = e.which;
        isCtrlKey = e.ctrlKey;
        isAltKey = e.altKey;
    }

    if (isCtrlKey == true) 
    {
        var retcode = byPassCtrlCode(keycode);
        if (retcode == true) 
        {
            var keyname = getVACtrlKeyName(keycode);
            if (_lastKeyPressed !== keyname && keyname != undefined) 
            {
                _lastKeyPressed = keyname;
                var msgInfo = 'button [CTRL-' + _lastKeyPressed + '] is pressed on keyboard.';
                jsWriteInfoTolog(msgInfo);
            }
            //
            // Do special actions: Open a balk window.                    
            if (keycode == 78 || keycode == 79 || keycode == 110 || keycode == 111) 
            {
                //Open a new browser with a blank url
                var _w = 600;
                var _h = 400;
                window.open('', '_blank', "center=yes,left=0,top=0,directories=0,modal=yes,resizable=1,location=1,status=0, toolbar=1,menubar=1, width=" + _w + ", height=" + _h);
            }
        }
    } 
    else if (isAltKey == true) 
    {
        var retcode = byPassAltCode(keycode);
        if (retcode == true) 
        {
            var keyname = getVAAltKeyName(keycode);
            if (_lastKeyPressed !== keyname && keyname != undefined) 
            {
                _lastKeyPressed = keyname;
                var msgInfo = 'button [ALT-' + _lastKeyPressed + '] is pressed on keyboard.';
                jsWriteInfoTolog(msgInfo);
            }
        }
    } 
    else 
    {
        var retcode = byPassSingleCode(keycode);
        if (retcode == true) 
        {
            var keyname = getVASingleKeyName(keycode);
            if (_lastKeyPressed !== keyname && keyname != undefined) 
            {
                _lastKeyPressed = keyname;
                var msgInfo = 'button [' + _lastKeyPressed + '] is pressed on keyboard.';
                jsWriteInfoTolog(msgInfo);
            }
        }
    }
}

function initVAToolBar() 
{
    var _f0 = gClassManager.getCloseSentinelFrame();    
    if (_f0 != null && _f0.VAInitToolBar != undefined) 
    {
        _f0.VAInitToolBar();
    }
}

function refreshVAToolbar() 
{
    onTBPageLoaded();
}

function canAgentForceLogout() 
{
    var retcode = false;
    var _f0 = gClassManager.getCloseSentinelFrame();
    if (_f0 != undefined && _f0.canVAForceLogout != undefined) 
    {
        retcode = _f0.canVAForceLogout();
    }
    return retcode;
}

function DetectTextEditor() 
{
    var activeElt = document.activeElement;
    if (activeElt != undefined && activeElt.tagName != undefined) 
    {
        if (activeElt.tagName == 'INPUT' || activeElt.tagName == 'TEXTAREA') 
        {
            return true;
        }
    }
    return false;
}



function enableRemoteButton( document , _btnId, _bSet) {

    if (_btnId != null && _btnId != undefined) {



        trace('enableRemoteButton>' + _btnId + ': bSet = ' + _bSet);
      
        // Change image of buttons
        if ('btnAccept' === _btnId || 'btnCancel' === _btnId) {

            var onclickelement = document.getElementById(_btnId);
            onclickelement.disabled = _bSet == true ? false : true;

            var buttonImgElement = document.getElementById(_btnId + 'Img');
            var _url = buttonImgElement.src;

            var _pos = _url.lastIndexOf('_dis.gif');
            if (false === _bSet && -1 === _pos) {
                buttonImgElement.src = _url.replace('.gif', '_dis.gif');
            }
            else if (_bSet && _pos != -1) {
                buttonImgElement.src = _url.replace('_dis.gif', '.gif');
            }

            var buttonSpanElement = document.getElementById(_btnId + 'Span');
            buttonSpanElement.style.color = _bSet == true ? "#000000" : "#848484";
        }
    }

    return;
}


function LocalTimeToUTC() 
{
    // create Date object for current location
    var d = new Date();

    // convert to msec since Jan 1 1970
    var localTime = d.getTime();

    // obtain local UTC offset and convertto msec
    var localOffset = getUTCOffsetInMSec();

    // obtain UTC time in msec
    var utc = localTime + localOffset;

    var nd = new Date(utc);

    // return time as a string
    var sLocalt = nd.toLocaleString;
}

function getUTCOffsetInMSec() 
{
    // create Date object for current location
    var d = new Date();

    // obtain local UTC offset and convert to msec
    // 1 minute = 60 seconds. 
    // 1 minute = 60000 msec.
    var localOffset = d.getTimezoneOffset() * 60000;

    return localOffset;
}

function utcToLocalTime(utcString) {
    // create Date object for  the input UTC time
    var myUTC = new Date(utcString);

    // obtain local UTC offset and convert to msec
    var localOffset = getUTCOffsetInMSec();

    // obtain local time in msec
    var localTime = myUTC - localOffset;

    //Format the date time string
    var rValue = getDatePart(localTime) + ' ' + getShortTimePart(localTime);

    return rValue;
}

function getTimePart(dateTimeString) 
{
    // create Date object for  the input UTC time
    var d = new Date(dateTimeString);

    var _hour = _hour = padLeft(d.getHours(), 2, '0');
    var _munites = padLeft(d.getMinutes(), 2, '0');
    var _second = padLeft(d.getSeconds(), 2, '0');

    //Format time string
    var rValue = _hour + ':' + _munites + ':' + _second;

    return rValue;
}

function getShortTimePart(dateTimeString) 
{
    // create Date object for  the input UTC time
    var d = new Date(dateTimeString);

    //Format time string
    var rValue = '';
    var _hour = d.getHours();
    var _munites = padLeft(d.getMinutes(), 2, '0');
    var _second = padLeft(d.getSeconds(), 2, '0');
    var isAM = true;

    if (_hour > 12) {
        isAM = false;
        _hour = _hour - 12;
    }

    _hour = padLeft(_hour, 2, '0');

    if (sAM == true) {
        rValue = _hour + ':' + _munites + ':' + _second + ' AM';
    } else {
        rValue = _hour + ':' + _munites + ':' + _second + ' PM';
    }

    return rValue;
}

function getDatePart(dateTimeString) 
{
    // create Date object for  the input UTC time
    var d = new Date(dateTimeString);

    //Format date string
    var _month = parseInt(d.getMonth()) + 1;

    var rValue = padLeft(d.getDate(), 2, '0') + '/' + padLeft(_month, 2, '0') + '/' + d.getFullYear();

    return rValue;
}

function padLeft(intValue, len, chr) 
{
    if (typeof (chr) == "undefined") chr = "0";
    var s = intValue.toString();
    return (s.length < len ? (new Array((len - s.length + 1)).join(chr)) + s : s);
}

function assignBackgroundForButton(className) 
{
    var _f1 = gClassManager.getToolbar();
    if (_f1 != undefined && _f1 != null && _f1.setButtonBackground != undefined)
    {
        _f1.setButtonBackground(className);
    }
}

function processProntoRemoteAnswer(_parm) {
    var _response = new Array();
    var listParms = _parm.split(';');
    if (listParms != null && listParms.length > 0) {
        if (listParms[0] == 'OK') {
            _response[0] = 'OK';
            processProntoStationParms(listParms);
        }
        else {
            _response[0] = 'ERR';
            if (listParms.length > 1) {
                var _retCode = getCommandResult(_parm);
                _response[1] = _retCode;
            }
        }
    }
    else {
        _response[0] = 'ERR';
    }

    return _response;
}

function publishEvent(event, userdata) {

    var data = userdata == undefined ? "" : userdata == null ? "" : userdata;
    try {
        gClassManager.getEventPublisher().publish(event, data);
    }
    catch (e) {
        Logger._warning("publishEvent> not able to publish newcall to external script -- error " + e.message);
    }
}

function processProntoStationParms(_parms) {
   // END US1190 Dial Delay implementation

    var AgentCallInfo = {};
    AgentCallInfo.exttype = "";
    AgentCallInfo.extphone = "";
    AgentCallInfo.dialer = "";
    AgentCallInfo.stationno = "";

    if (_parms != null && _parms.length > 1) {
        for (var i = 0; i < _parms.length; i++) {
            keyval = _parms[i].split(':');
            if (keyval != null && keyval.length == 2) {
                if (keyval[0] === 'EXTTYPE') {
                    AgentCallInfo.exttype = keyval[1];
                }
                else if (keyval[0] === 'EXTPHONE') {
                    AgentCallInfo.extphone = keyval[1];
                }
                else if (keyval[0] === 'DIALER') {
                    AgentCallInfo.dialer = keyval[1];
                }
                else if (keyval[0] === 'STATIONNO') {
                    AgentCallInfo.stationno = keyval[1];
                }
            }
    }

    var additionnalSetting = {};
    additionnalSetting.async = false;

    iCommon.callServerMethod("CloseSentinel.aspx", "SetAgentCallInfo", { AgentCallInfo: AgentCallInfo }, null, function (xhr, msg, e) { }, additionnalSetting);

        var _ConfigClass = gClassManager.getConfigManager();
        if (_ConfigClass != undefined) {
            _ConfigClass.setRemoteAgentCallInfo(AgentCallInfo);
        }     
    }
}

function verIE() {
    if (_IEVersion == 0) {
        var ver = 0;

        if (navigator.appName == 'Microsoft Internet Explorer') {
            var ua = navigator.userAgent;
            var re = new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
            var res = re.exec(ua);
            if (res != null) {
                ver = parseFloat(res[1]);
            }
            _IEVersion = ver;
        }

    }

    return _IEVersion;
}


/*RK: File Created: March 20, 2013 */
//how to use it! $.clientID("PriorityDropDownlist") or $.getElementByIdEx("PriorityDropDownlist")
$.extend({
    clientID: function (_id) {
        return $("[id$='" + _id + "']");
    }
});

$.extend({ //RK. instead of changing all code to jQuery. we just replace the js getDocumentById -- Less risk and time.
    getElementByIdEx: function (_id) {
        return $("[id$='" + _id + "']")[0];
    }
});

//RK:this function verifies if a checkbox jquery object is checked
$.fn.isChecked = function () {
    return $(this.selector + ':checked').length;
};

//RK:this function will disable the object (very good for infragistics)
$.fn.disable = function () {
    return this.each(function () {
        if (typeof this.disabled != "undefined") this.disabled = true;
    });
};

//RK:this function will enable the object (very good for infragistics)
$.fn.enable = function () {
    return this.each(function () {
        if (typeof this.disabled != "undefined") this.disabled = false;
    });
};


//US1228: Advanced features

//RK:Generates Guid version 4 compliant
function getGuid() {
    'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (_c) {
        var r = Math.random() * 16 | 0, v = _c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}

function fillPreconfiguredNumbers(_reset) {

    var _ConfigClass = gClassManager.getConfigManager();
    if (_ConfigClass == undefined || _ConfigClass.GetAdvanceSettingClass() == null) {
        return;
    }

    var advanceSetting = _ConfigClass.GetAdvanceSettingClass();

                if (_reset) {
                    $('#slPreconfiguredLines').find('option').remove().end();
                }

    $("#slPreconfiguredLines").addItemsToPreconfiguredLines(advanceSetting.m_selectOptions);
                if (_reset) {
                    $("select[id$=slConnectedLines] > option").each(function (_index, _itemData) {
                        $("#slPreconfiguredLines option[value='" + this.text.replace("[" + $("#PH_C").val() + " ] ", "").replace("[" + $("#PH_H").val() + "]" + "] ", "") + "']").remove();
                    });
                }
                
    if ($("#slPreconfiguredLines").length === 0 && $("#txtDialNumber").is(':disabled'))
                    $("#slConnectedLines option[value='0']").remove();
            }

// Callback for the answer of the Advanced message send to Pronto
function NotifyProntoAdvancedCB(_bOk, _wsCallAdvanced) {
    trace('NotifyProntoAdvancedCB=' + _bOk);
    var _bErr = true;
    var _errMsg = null;
    var _isPolling = false;
    var toolbar = gClassManager.getToolbar();
    
    try {
        toolbar.setLastCallResultMsg("");
    }
    catch (e) {
    }

    try {
      
        var dialog = gClassManager.getDialogObject();
        var Logger = gClassManager.getNewLogger();

        var response = arguments[2].split('//');
        var _f0 = gClassManager.getCloseSentinelFrame();
        if (false === _bOk) {
            Logger._error('NotifyProntoAdvancedCB: Advanced command failed. ' +_wsCallAdvanced.getErrorMessage());
        }
        else if (response.length > 1) {
            var typeOfAnswer = typeOfWaitAnswer(response[1]);

            Logger._trace('NotifyProntAdvancedCB; TypeOfAnswer: ' + typeOfAnswer + '; ' +response[1]);
            if (typeOfAnswer === 'OK') {
                switch (response[0].toUpperCase()) {
                    case "HOLD":
                        var eventHold = $("#holdhidden").val();
                        switch (eventHold) {
                            case "slConnectedLinesChanged":
                                $("#btnHold").css("display", "none");
                                $("#divNew").css("display", "");

                                fillPreconfiguredNumbers(true);
                                lineHold = $("#holdLine").val();
                                $("select[id$=slConnectedLines] > option").each(function (_index, _itemData) {
                                    var isC = this.text.indexOf($("#PH_C").val() + "]");
                                    var lineNo = _itemData.value;
                                    if (isC > 0) {
                                        this.text = this.text.replace("[" + $("#PH_C").val() + "]", "[" + $("#PH_H").val() + "]");
                                        toolbar.setLineStatus(lineNo, ADVST_HOLD);
                                        if (!this.className === "")
                                            this.className = "onHold";
                                    }
                                });
                                $("#holdhidden").val("");
                                break;
                            case "btnHoldClicked":
                                //$("#slConnectedLines :selected").text($("#slConnectedLines :selected").text().replace("[" + $("#PH_C").val() + "]", "[" + $("#PH_H").val() + "]"));
                                //if (!$("#slConnectedLines :selected").hasClass("onHold"))
                                //    $("#slConnectedLines :selected").addClass("onHold");
                                lineHold = $("#holdLine").val();
                                $("select[id$=slConnectedLines] > option").each(function (_index, _itemData) {
                                    var lineNo = _itemData.value;
                                    //if (lineNo == lineHold) {
                                    var isC = this.text.indexOf($("#PH_C").val() + "]");
                                    if (isC > 0) {
                                        this.innerText = this.text.replace("[" +$("#PH_C").val() + "]", "[" +$("#PH_H").val() + "]");
                                        toolbar.setLineStatus(lineNo, ADVST_HOLD);
                                        if (!this.className === "")
                                            this.className = "onHold";
                                    }
                                    //}

                                });
                                $("#holdLine").val(0);
                                $("#btnHold").val($("#PH_Resume").val());
                                $("#holdhidden").val("");
                                break;
                            default:
                                break;
                        }

                        if (toolbar.getisRespondentLineOnHold()) {
                            toolbar.enableTbButton('btnHangup', false);
                        }
                        $("#btnAdvancedHangup").prop("disabled", true);

                        break;
                    case "UNHOLD":
                        var eventUnhold = $("#unholdhidden").val();
                        switch (eventUnhold) {
                            case "btnHoldClicked":
                                $("#unholdhidden").val("");
                                lineHold = $("#holdLine").val();
                                $("select[id$=slConnectedLines] > option").each(function (_index, _itemData) {
                                    var lineNo = _itemData.value;
                                    if (lineNo == lineHold) {
                                        var isC = this.text.indexOf($("#PH_H").val() + "]");
                                        if (isC > 0) {
                                            this.text = this.text.replace("[" + $("#PH_H").val() + "]", "[" + $("#PH_C").val() + "]");
                                            toolbar.setLineStatus(lineNo, ADVST_CONNECTED);
                                            if (!this.className === "")
                                                this.className = "onHold";
                                        }
                                    }
                                    else {
                                        var isC = this.text.indexOf($("#PH_C").val() + "]");
                                        if (isC > 0) {
                                            this.text = this.text.replace("[" + $("#PH_C").val() + "]", "[" + $("#PH_H").val() + "]");
                                            toolbar.setLineStatus(lineNo, ADVST_HOLD);
                                            if (!this.className === "")
                                                this.className = "onHold";
                                        }

                                    }

                                });
                                $("#holdLine").val(0);
                                $("#slConnectedLines :selected").text($("#slConnectedLines :selected").text().replace("[" + $("#PH_H").val() + "]", "[" + $("#PH_C").val() + "]"));
                                if ($("#slConnectedLines :selected").hasClass("onHold"))
                                    $("#slConnectedLines :selected").removeClass("onHold");
                                $("#btnHold").val($("#PH_Hold").val());
                                break;
                            default:
                                break;
                        }

                        if (toolbar.getisRespondentLineOnHold() == false ) {
                            toolbar.enableTbButton('btnHangup', true);
                        }
                        $("#btnAdvancedHangup").prop("disabled", false);
                        //
                        break;

                    case "AGENT-CALL":

                        //Update _lineNos hash, very very important to maintain.
                        var responses = response[1].split(';');
                        var responseLine = responses[4].split(':');
                        var connectedLine = 0;
                        if (responseLine == undefined) {
                            warning("NotifyProntoAdvancedCB> No line number for AGENT CALL in advance!");
                        }
                        else {
                            try {
                                connectedLine = responseLine[1];
                            }
                            catch (e) {
                                error("NotifyProntoAdvancedCB> EXCEPTION for line number for AGENT CALL in advance! Exception: " + e.message);
                            }
                        }

                        $("#divNew").css("display", "none");
                        $("#btnHold").css("display", "");
                        $("#btnHold").prop("disabled", false);
                        if (_hasRightForTransfer) {
                            $("#btnTransfer").css("display", "");
                            $("#btnTransfer").prop("disabled", false);
                        }
                        if (_hasRightForConference) {
                            $("#btnConference").css("display", "");
                            $("#btnConference").prop("disabled", false);
                        }
                        $("#btnAdvancedHangup").css("display", "");
                        $("#btnAdvancedHangup").prop("disabled", false);
                        $("#slConnectedLines option[value='0']").remove();
                        $("#slConnectedLines").append($('<option>', { value: connectedLine }, { selected: "selected" }).text("[" + $("#PH_C").val() + "] " + $("#txtDialNumber").val()));
                        $("#slConnectedLines option[value = '" + connectedLine + "']").attr("selected", true);

                        $("#txtDialNumber").val($("#PH_EnterNumber").val());
                        $("#btnDial").prop("disabled", false);

                        $("#btnHold").val($("#PH_Hold").val()); //Definitely a hold since the newly connected line is in C mode.


                        _lineNos = toolbar.getLineNos();
                        toolbar.setNewCall($("#nbr2dial").val(), connectedLine);
                        //_lineNos.put($("#nbr2dial").val(), connectedLine); //phoneNo => lineNo OK;0;MODE:O;DIALING-MODE:0;LINE:2
                        //f1.setLineNos(_lineNos);
                        $("#nbr2dial").val("");
                        //
                        break;

                    case "TRANSFER-CALL":
                        $('#slConnectedLines').find('option').remove().end();
                        $('#slConnectedLines').html('');
                       
                        toolbar.resetCallList();
                        closeDialog();

                        // DE11992  le netoyyage de la liste ce fait a l'interview complete
                        createPLCookie('Dialed', false, 1); // No more in call
                    
                        _f0.setAppStatus(_STATUS_WRAPUP);
                        break;

                    case "CONFERENCE":
                        $("#slConnectedLines > option").each(function (_index, _itemData) {
                            var isC = this.text.indexOf($("#PH_H").val() + "]");
                            if (isC > 0) {
                                this.innerText = this.text.replace("[" + $("#PH_H").val() + "]", "[" + $("#PH_C").val() + "]");
                                if ($(this).hasClass("onHold"))
                                    $(this).removeClass("onHold");
                            }
                        });


                        if (_hasRightForTransfer) {
                            $("#btnTransfer").css("display", "");
                            $("#btnTransfer").prop("disabled", false);
                        }

                        $("#btnHold").val($("#PH_Hold").val()); //Definitely a hold since both lines are in conference
                        $("#btnConference").css("display", "none");
                        $("#btnConference").prop("disabled", false);

                        // All lines are now connected
                        _lineNos = toolbar.getLineNos();
                        aKeyArray = _lineNos.keys();
                        if (aKeyArray.length > 0) {
                            for (i = 0; i < aKeyArray.length; i++) {
                                toolbar.setLineStatus(_lineNos.get(aKeyArray[i]), ADVST_CONNECTED);
                            }
                        }

                        toolbar.setisRespondentLineOnHold(false);
                        toolbar.enableTbButton('btnHangup', true);
                        break;

                    case "CALL-DISCONNECT":
                        if ($("#slConnectedLines :selected").val() !== undefined) {
                            $("#slConnectedLines :selected").remove();
                            $("#slConnectedLines").append($('<option>', { value: '0' }).text($("#PH_slopNew").val()));
                            $("#btnTransfer").css("display", "none");
                            $("#btnTransfer").prop("disabled", false);
                            $("#btnConference").css("display", "none");
                            $("#btnConference").prop("disabled", false);

                            $("#btnAdvancedHangup").css("display", "none");
                            $("#btnAdvancedHangup").prop("disabled", false);

                            $("#txtDialNumber").addClass("search_init");
                            $("#btnHold").prop("disabled", false);
                            $("#btnHold").css("display", "");


                            //Update _lineNos hash, very very important to maintain.
                            _lineNos = toolbar.getLineNos();
                            _lineNos.remove($("#nbr2Hangup").val());
                            toolbar.setLineNos(_lineNos);
                            $("#nbr2Hangup").val("");
                            ////

                        }
                        break;
                    case "HANGUP":
                        if ($("#slConnectedLines :selected").val() !== undefined) {
                            $("#slConnectedLines :selected").remove();
                            $("#slConnectedLines").append($('<option>', { value: '0' }).text($("#PH_slopNew").val()));
                            $("#btnTransfer").css("display", "none");
                            $("#btnTransfer").prop("disabled", false);
                            $("#btnConference").css("display", "none");
                            $("#btnConference").prop("disabled", false);
                            $("#btnAdvancedHangup").css("display", "none");
                            $("#btnAdvancedHangup").prop("disabled", false);
                            $("#txtDialNumber").addClass("search_init");
                            $("#btnHold").prop("disabled", false);
                            $("#btnHold").css("display", "");


                        

                            var myRespondantLine = toolbar.getPrimaryLine();
                            var iNbLinesConnected = toolbar.hangupLine($("#nbr2Hangup").val());

                        //
                            //  Pourquoi cette variables intermediaire si le frame toolbar contient deja l'information ... 
                        //
                        _lineNos.remove($("#nbr2Hangup").val());
                        toolbar.setLineNos(_lineNos);
                        $("#nbr2Hangup").val("");


                        //
                        //  On tente de trouver le numero de lignes 
                        //
                        var line = '0';
                        var responses = response[1].split(';');
                        if (responses.length > 1) {

                            var responseLine = responses[1].split(':');
                            if (responseLine.length > 1) {
                                line = responseLine[1];
                            }
                        }

                        //
                        // Si nous sommes la ligne du repondant. Nous mettons le status de l'agent en wrapup
                            //  DE11789 + DE11814 ( createPLCookie )
                            //
                     
                        if (myRespondantLine != undefined && myRespondantLine != null && myRespondantLine == line) {

                            //
                            //  DE13659 on doit egalement dire a l'objet dial pad que la ligne du repondant est libere en mode advance
                            //


                    
                            if (gClassManager.getAgentAssignmentClass().isManualDialingProject() == true) {
                                gClassManager.getCustomDialPad().Disconnect();
                            }

                          //  var callclass = gClassManager.getCallClass();
                          //  callclass.setInCall(false);

                            setStatus(_STATUS_WRAPUP);
                            createPLCookie('Dialed', false, 1); // No more in call
                            closeDialog();
                            break;
                        }

                        if (iNbLinesConnected == 0) {
                            // DE11889 ...  si nous n'avons plus personne en ligne nous fermons le dialogue de l'advance.

                            if (gClassManager.getAgentAssignmentClass().isManualDialingProject() == true) {
                                gClassManager.getCustomDialPad().Disconnect();
                            }

                            closeDialog();
                        }

                        break;
                }
            }
            }
            else if (typeOfAnswer === 'ERR') {
                error('NotifyProntoAdvancedCB; Error: ' + response[0].toUpperCase() + " : " + response[1]);
                switch (response[0].toUpperCase()) {
                    case "HOLD":
                        if (toolbar.getisRespondentLineOnHold()) {
                            toolbar.setisRespondentLineOnHold(false);
                            toolbar.enableTbButton('btnHangup', true);
                        }
                        dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                        break;
                    case "UNHOLD":
                        dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                        break;
                    case "AGENT-CALL":
                        $("#btnDial").prop("disabled", true);
                        $("#txtDialNumber").val($("#PH_EnterNumber").val());
                        $("#txtDialNumber").addClass("search_init");
                        $("select[id$=slPreconfiguredLines] > option").each(function (_index, _itemData) {
                            $(this).removeAttr("selected");
                        });

                        //DE9583
                        if (response[1] === "ERR;NO-ADV-LINE") {
                            dialog.showAlert(getTranslatedString("STR_NO_ADV_LINE"));
                        } else {
                            dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                        }
                        break;
                    case "TRANSFER-CALL":
                        dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                        break;
                    case "CONFERENCE":
                        dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                        break;
                    case "CALL-DISCONNECT":
                        dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                        break;
                    case "HANGUP":
                        dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                        break;

                }
            }
        }
    }
    catch (e) {
        error("NotifyProntoAdvancedCB> caugth a java script exception in advance when processing response from telephony server: " + e.message);
    }

    //if (_isPolling && _bErr === false) {

    _wsCallAdvanced = null;

}



//
// Creation of the Ajax method to send Advanced message to WebService
function AdvancedWebServiceCall(_actionName, _lineNo, _linegroup) {

    var dialog = gClassManager.getDialogObject();

    var usedId = ReadUserId("AdvancedWebServiceCall", getTranslatedString("STR_INVALID_USERID"), false);
    if (null === usedId) {
        error('AdvancedWebServiceCall> button ' + _actionName + ' is cancelled. The user Id is not valid.');
        return false;
    }

    var wsCalladvanced = new WebServiceCall(this.location.protocol + "//" + this.location.hostname + "/Voxco.Agent.WebService/PHService.asmx", _actionName);
    if (wsCalladvanced != null) {
        switch (_actionName) {
            case "AgentHold":
                wsCalladvanced.setParams(new Array('_userId', usedId));
                if (null === wsCalladvanced.getAjaxObj()) {
                    dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                    wsCalladvanced = null;
                    return (false);
                }
                break;
            case "TransferCall":
                wsCalladvanced.setParams(new Array('_userId', usedId));
                if (null === wsCalladvanced.getAjaxObj()) {
                    dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                    wsCalladvanced = null;
                    return (false);
                }
                break;
            case "Conference":
                wsCalladvanced.setParams(new Array('_userId', usedId));
                if (null === wsCalladvanced.getAjaxObj()) {
                    dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                    wsCalladvanced = null;
                    return (false);
                }
                break;
            case "AgentUnHold":
                if (_lineNo == "") return;
                //if (_lineNos.size() === 0) DE9580. Preview, hybrid reserve a line then use another on dial, then it is useless to use the lineNos hash of PH_Scripts. Should set it back every time from VerticalTb local hash.
                wsCalladvanced.setParams(new Array('_userId', usedId, '_lineNo', _lineNo));
                if (null === wsCalladvanced.getAjaxObj()) {
                    dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                    wsCalladvanced = null;
                    return (false);
                }
                break;
            case "AgentHangup":
                if (_lineNo == "") return;
                //if (_lineNos.size() === 0) DE9580. Preview, hybrid reserve a line then use another on dial, then it is useless to use the lineNos hash of PH_Scripts. Should set it back every time from VerticalTb local hash.
                wsCalladvanced.setParams(new Array('_userId', usedId, '_lineNo', _lineNo));
                if (null === wsCalladvanced.getAjaxObj()) {
                    dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                    wsCalladvanced = null;
                    return (false);
                }
                break;

            case "AgentCall":
                _phoneNoSaved = _lineNo;
                wsCalladvanced.setParams(new Array('_userId', usedId, '_phoneNo', _lineNo,'linegroup', _linegroup, 'usetpl', false, '_sessId',''));
                if (null === wsCalladvanced.getAjaxObj()) {
                    dialog.showAlert(getTranslatedString("STR_EXECUTE_PRONTOCMD_FAILED"));
                    wsCalladvanced = null;
                    return (false);
                }
                break;
            default:
                wsCalladvanced = null;
                break;
        }
        if (wsCalladvanced != null) {
            wsCalladvanced.execute(NotifyProntoAdvancedCB);
        }
    }

    return true;
}


//Advanced features
